#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtGui>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.lemmurg.mwqtubestatus")

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void closeEvent(QCloseEvent *event);
    void changeEvent(QEvent *e);

    /**
     * Updates the model with the data currently in 'response'.
     */
    void updateModel();

    void readSettings();
    void writeSettings() const;

private:
    Ui::MainWindow *ui;
    QVariantMap response;

    QSettings * settings;

    QTableView * dataView;
    QLabel * lastUpdatedLabel;

    bool updateRunning;
    QTimer *timer;
    QMutex mutex;

    QNetworkAccessManager *netMan;

    // Settings
    int rotationMode;
    bool autoUpdate;
    bool autoConnect;

public slots:
    Q_SCRIPTABLE int top_application();
    
    void setRotationMode(int rotationMode, bool force=false);
    void setAutoConnect(bool autoConnect, bool force=false);
    void setAutoUpdate(bool autoUpdate, bool force=false);

private slots:
    void on_action1_Column_triggered();
    void on_action2_Columns_triggered();
    void on_actionSettings_triggered();
    void on_actionAbout_triggered();
    void on_actionUpdate_triggered();
    void onGetTubeUpdateFinished(QNetworkReply * reply);
    void onTubeStatusPressed(const QModelIndex & index);
#if defined(Q_WS_MAEMO_5)
    void orientationChanged();
#endif
    void startAutoUpdateTimer();
    void stopAutoUpdateTimer();
};


#endif // MAINWINDOW_H
