#include "mainwindow.h"

#include <QtDBus>
#include <QtGui/QApplication>
 
int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    MainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    if (!QDBusConnection::sessionBus().isConnected()) {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }

    if (!QDBusConnection::sessionBus().registerService("com.lemmurg.mwqtubestatus")) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().message()));
        exit(2);
    }

    if (!QDBusConnection::sessionBus().registerObject("/com/lemmurg/mwqtubestatus", &w,
            QDBusConnection::ExportScriptableSlots)) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().message()));
        exit(3);
    }
    w.show();
#endif
    return a.exec();
}
