#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore>
#include <QCoreApplication>
#include "dabout.h"


MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->label->hide();

    netAccessMan = new QNetworkAccessManager(this);
    netAccessManStream = new QNetworkAccessManager(this);
    connect(netAccessMan, SIGNAL(finished(QNetworkReply*)), this, SLOT(downloadFinished(QNetworkReply*)));
    connect(netAccessManStream, SIGNAL(finished(QNetworkReply*)), this, SLOT(streamFinished(QNetworkReply*)));
    ui->plainTextEdit->hide();
    links = new QStringList();

    music =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource(""));
}

MainWindow::~MainWindow()
{
    delete ui;
    delete links;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)

    showMaximized();
#else
    show();
#endif
}

void MainWindow::download(QString item){
    QUrl url(item);
    QNetworkRequest request(url);
    netAccessMan->get(request);
}

void MainWindow::stream(QString item){
    QUrl url(item);
    QNetworkRequest request(url);
    netAccessManStream->get(request);
}

void MainWindow::on_btnSearch_clicked()
{
    if (ui->edtSong->text().simplified().count()>0){
	ui->plainTextEdit->hide();
	download("http://goear.com/search.php?q="+ui->edtSong->text());
    }else{
	ui->edtSong->setText("You Must Provide a Name");
    }
}

void MainWindow::downloadFinished(QNetworkReply *reply)
{
    if (reply->error() != QNetworkReply::NoError) {
	//qDebug() << "Error in" << reply->url() << ":" << reply->errorString();
	ui->edtSong->setText("Goear is Down");
	reply->deleteLater();
	return;
    }
    QVariant redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute);
    if (redir.isValid()) {
	QUrl url = redir.toUrl();
	//qDebug() << "must go to:" << url;
	if (url.isRelative()) {
	    url.setScheme(reply->url().scheme());
	    url.setEncodedHost(reply->url().encodedHost());
	}
	QNetworkRequest req(url);
	netAccessMan->get(req);
	reply->deleteLater();
	return;
    }
   // qDebug() << "ContentType:" << reply->header(QNetworkRequest::ContentTypeHeader).toString();

    downloadedItem = reply->readAll();

    if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/xml"){
	QString link=downloadedItem;

	//ui->plainTextEdit->show();
	ui->plainTextEdit->document()->setPlainText(downloadedItem);

	int linkBegins=link.indexOf("path=\"")+6;
	int linkEnds=link.indexOf("\"",linkBegins);
	link=link.mid(linkBegins,linkEnds-linkBegins);
	//ui->edtSong->setText(link);
	ui->plainTextEdit->clear();
	//ui->plainTextEdit->hide();

	download(link);

    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/html"){
	ui->lstItems->clear();
	links->clear();
	QString songs;
	ui->plainTextEdit->document()->setPlainText(downloadedItem);
	songs.append(ui->plainTextEdit->document()->findBlockByLineNumber(129).text());

	ui->plainTextEdit->clear();

	int count=songs.count("listen/");
	for (int var=0;var<count;var++){
	    int escucharBegins=songs.indexOf("title=\"Escuchar");
	    int escucharEnds=songs.indexOf("\"",escucharBegins+16);

	    int listenBegins=songs.indexOf("listen/");
	    int listenEnds=songs.indexOf("/",listenBegins+7);

	    links->append(songs.mid(listenBegins+7,listenEnds-listenBegins-7));
	    ui->lstItems->addItem(songs.mid(escucharBegins+16,escucharEnds-escucharBegins-16));
	    songs=songs.mid(listenEnds)+1;
	}
    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="audio/mpeg"){

	//QString sf = "MP3 files (*.mp3)";
	//QString name = QFileDialog::getSaveFileName(this, tr("Save File"),"/home/user/MyDocs/",tr("MP3 files (*.mp3)"),&sf,QFileDialog::DontUseNativeDialog);

	QString name=QFileDialog::getSaveFileName(this,"Select a File","/home/user/MyDocs/", "MP3 Files (*.mp3)");
	if (name.indexOf(".mp3")==-1){
	    name=name+".mp3";
	}



	QFile file(name);
	file.open(QIODevice::WriteOnly);
	QDataStream out(&file);
	out << downloadedItem;
	ui->plainTextEdit->hide();
	//ui->edtSong->setText("Downloaded");

	ui->btnDownload->setEnabled(true);
	ui->label->setVisible(false);
	delete movie;
    }
    else{
	ui->edtSong->setText(reply->header(QNetworkRequest::ContentTypeHeader).toString());
    }

    reply->deleteLater();
}

void MainWindow::on_btnDownload_clicked()
{
    if (ui->lstItems->currentRow()>-1){
	    ui->plainTextEdit->show();
	    download("http://www.goear.com/tracker758.php?f="+links->at(ui->lstItems->currentRow()));

	    ui->label->setVisible(true);
	    movie = new QMovie(":/loading.gif");

	    if (movie->isValid()){
		ui->label->setMovie(movie);
		movie->start();
	    }else{
		ui->label->setPixmap(QPixmap(":/loading.gif"));
	    }

	    ui->btnDownload->setDisabled(true);

	}
}

void MainWindow::on_actionAbout_triggered()
{
    DAbout *dAbout;
    dAbout=new DAbout(0);
    dAbout->exec();
    delete dAbout;
}

void MainWindow::on_btnPlay_clicked(){
    //if (music)
    if (music->state()==2){
	music->pause();
	ui->btnPlay->setText("Play");
    }else if (music->state()==4){
	music->play();
    }else{
	music->clear();
	if (ui->lstItems->currentRow()>-1){
	    stream("http://www.goear.com/tracker758.php?f="+links->at(ui->lstItems->currentRow()));
	}
    }
}

void MainWindow::streamFinished(QNetworkReply *reply)
{
    if (reply->error() != QNetworkReply::NoError) {
	ui->edtSong->setText("Network Problem Can't access Goear");
	reply->deleteLater();
	return;
    }
    QVariant redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute);
    if (redir.isValid()) {
	QUrl url = redir.toUrl();
	if (url.isRelative()) {
	    url.setScheme(reply->url().scheme());
	    url.setEncodedHost(reply->url().encodedHost());
	}
	QNetworkRequest req(url);
	netAccessMan->get(req);
	reply->deleteLater();
	return;
    }

    downloadedItem = reply->readAll();

    if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/xml"){
	QString link=downloadedItem;

	ui->plainTextEdit->document()->setPlainText(downloadedItem);

	int linkBegins=link.indexOf("path=\"")+6;
	int linkEnds=link.indexOf("\"",linkBegins);
	link=link.mid(linkBegins,linkEnds-linkBegins);
	//ui->edtSong->setText(link);
	ui->plainTextEdit->clear();
	//ui->plainTextEdit->hide();

	QUrl url=link;

	music->clearQueue();
	music->enqueue(url);
	music->play();
	ui->btnPlay->setText("Pause");
	ui->btnStop->setEnabled(true);

    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/html"){
	ui->lstItems->clear();
	links->clear();
	QString songs;
	ui->plainTextEdit->document()->setPlainText(downloadedItem);
	songs.append(ui->plainTextEdit->document()->findBlockByLineNumber(129).text());

	ui->plainTextEdit->clear();

	int count=songs.count("listen/");
	for (int var=0;var<count;var++){
	    int escucharBegins=songs.indexOf("title=\"Escuchar");
	    int escucharEnds=songs.indexOf("\"",escucharBegins+16);

	    int listenBegins=songs.indexOf("listen/");
	    int listenEnds=songs.indexOf("/",listenBegins+7);

	    links->append(songs.mid(listenBegins+7,listenEnds-listenBegins-7));
	    ui->lstItems->addItem(songs.mid(escucharBegins+16,escucharEnds-escucharBegins-16));
	    songs=songs.mid(listenEnds)+1;
	}
    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="audio/mpeg"){


    }
    else{
	ui->edtSong->setText(reply->header(QNetworkRequest::ContentTypeHeader).toString());
    }

    reply->deleteLater();
}

void MainWindow::on_btnStop_clicked()
{
    music->stop();
    ui->btnStop->setEnabled(false);
    ui->btnPlay->setText("Play");
}
