/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef BLUETOOTH_P_H
#define BLUETOOTH_P_H

#include "bluetooth.h"

QTM_BEGIN_NAMESPACE
class QBluetoothDeviceDiscoveryAgent;
class QBluetoothServiceDiscoveryAgent;
class QBluetoothTransferManager;
QTM_END_NAMESPACE

QTM_USE_NAMESPACE

class QFile;

class BluetoothPrivate
{

public:
    BluetoothPrivate(Bluetooth *parent);
    virtual ~BluetoothPrivate();

    void _q_onDeviceDiscoveryFinished();
    void _q_onServiceDiscoveryFinished();
    void _q_onSocketConnected();
    void _q_onSocketDisconnected();
    void _q_onSocketReadyRead();
    void _q_onSocketStateChanged(QBluetoothSocket::SocketState state);
    void _q_onSocketError(QBluetoothSocket::SocketError error);
    void _q_onReplyFinished(QBluetoothTransferReply *reply);

    Bluetooth *q_ptr;

    QBluetoothDeviceDiscoveryAgent *deviceAgent;
    QBluetoothServiceDiscoveryAgent *serviceAgent;

    QBluetoothSocket *socket;

    QBluetoothTransferManager *manager;

    QFile *file;

    Q_DECLARE_PUBLIC(Bluetooth)
};

#endif // BLUETOOTH_P_H
