/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Item {
    id: root

    property alias title: titleLabel.text
    property string key
    property string handler

    function setKey(key, defaultValue) {
        root.key = key;
        var value = Settings.setting(key);

        if (value === undefined) {
            value = defaultValue;
        }

        textField.text = value;
        textField.initialised = true;
    }

    height: 80
    width: !parent ? implicitWidth : parent.width

    Label {
        id: titleLabel

        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            top: parent.top
        }

        font.bold: true
        elide: Text.ElideRight
    }

    TextField {
        id: textField

        property bool initialised: false

        anchors {
            left: parent.left
            leftMargin: 30
            right: parent.right
            rightMargin: 30
            top: titleLabel.bottom
            topMargin: UI.PADDING_DOUBLE
        }

        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
        platformSipAttributes: SipAttributes {
            actionKeyEnabled: textField.text != ""
            actionKeyHighlighted: true
            actionKeyLabel: qsTr("Done")
            actionKeyIcon: ""
        }

        Keys.onEnterPressed: textField.platformCloseSoftwareInputPanel()
        Keys.onReturnPressed: textField.platformCloseSoftwareInputPanel()

        onTextChanged: {
            if (!initialised) {
                return;
            }

            Settings.setSetting(root.key, textField.text);

            if (root.handler) {
                ScriptEngine.eval(root.handler);
            }
        }
    }
}
