/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0
import "controls"

Page {
    id: root

    property Item pageStackControl: null

    function loadRemote(name) {
        if (RemoteLoader.loadRemote(name)) {
            pageStackControl = RemoteLoader.loadUi(root);
            pageStackControl.parent = root;
            RemoteLoader.loadSettings();
            RemoteLoader.loadPlugins();
        }
    }

    tools: ToolBarLayout {

        ToolIcon {
            anchors.right: parent.right
            platformIconId: "toolbar-view-menu"
            onClicked: menu.open()
        }
    }

    PageHeader {
        id: header

        text: RemoteLoader.remoteName ? RemoteLoader.remoteName : "MultiMote"

        MouseArea {
            anchors.fill: parent
            onClicked: pageStackControl.nextPage()
        }
    }

    Menu {
        id: menu

        MenuLayout {

            ValueMenuItem {
                title: qsTr("Remote")
                subTitle: RemoteLoader.remoteName ? RemoteLoader.remoteName : qsTr("None chosen")
                onClicked: {
                    dialogLoader.sourceComponent = remoteSelector;
                    dialogLoader.item.open();
                }
            }

            MenuItem {
                text: RemoteLoader.remoteName + " " + qsTr("settings")
                visible: RemoteLoader.remoteName != ""
                onClicked: pageStack.push(Qt.resolvedUrl("RemoteSettingsPage.qml"))
            }

            MenuItem {
                text: qsTr("About") + " " + RemoteLoader.remoteName
                visible: RemoteLoader.remoteName != ""
                onClicked: pageStack.push(Qt.resolvedUrl("RemoteAboutPage.qml"))
            }

            MenuItem {
                text: qsTr("MultiMote settings")
                onClicked: pageStack.push(Qt.resolvedUrl("SettingsPage.qml"))
            }

            MenuItem {
                text: qsTr("About MultiMote")
                onClicked: pageStack.push(Qt.resolvedUrl("AboutPage.qml"))
            }
        }
    }

    Loader {
        id: loader
    }

    Loader {
        id: dialogLoader
    }

    Component {
        id: noRemoteItem

        NoRemoteItem {}
    }

    Component {
        id: remoteSelector

        ValueDialog {
            model: RemoteListModel {
                id: remoteModel
            }
            onValueChanged: loadRemote(value)
        }
    }

    //    Component.onCompleted: {
    //        if ((Settings.loadRemoteOnStartup) && (Settings.currentRemote)) {
    //            loadRemote(Settings.currentRemote);
    //        }
    //        else {
    //            loader.sourceComponent = noRemoteItem;
    //        }
    //    }

    Component.onCompleted: loadRemote("HelloWorld")
}
