/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Page {
    id: root

    property string title

    function addItem(item) {
        grid.addItem(item);
    }

    Flickable {
        id: flicker

        anchors.fill: parent
        contentHeight: grid.height + UI.PADDING_DOUBLE * 2

        Grid {
            id: grid

            property variant rows
            property variant columns

            property variant items: []

            function addItem(item) {
                var i = items;
                i.push(item);
                items = i;
                item.parent = grid;
            }

            function loadPortraitLayout() {

            }

            function loadLandscapeLayout() {

            }

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
                margins: UI.PADDING_DOUBLE
            }
        }
    }

    ScrollDecorator {
        flickableItem: flicker
    }
}
