/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

var services = {};

function keyNav(event) {
    switch (event.key) {
    case Qt.Key_Left:
        pageStack.previousPage();
        return;
    case Qt.Key_Right:
        pageStack.nextPage();
        return;
    default:
        return;
    }
}

function sendRemoteKey(key) {
    http.get(ipaddress + "/cgi-bin/rc?" + key);
}

function setVolume(volume) {
    http.get(ipaddress + "/setVolume?volume=" + volume);
}

function toggleMute(xy) {
    http.get(ipaddress + "/setVolume?mute=" + xy);
}

function loadServices(ref, callback) {
    http.get(ipaddress + "/cgi-bin/getServices?ref=" + ref, {}, callback ? callback : "");
}

function populateServices(response) {
    var list = response.split("\n");

    for (var i = 0; i < list.length; i++) {
        var s = list[i].split(";");
        services[s[1]] = s[0];
    }
}

function loadBouquets() {
    bouquetSelector.clear();
    loadServices(services["Bouquets (TV)"], "populateBouquetList");
}

function populateBouquetList(response) {
    bouquetSelector.addItem(qsTr("All services"), services["All services (TV)"]);
    bouquetSelector.addItem(qsTr("History"), services["History"]);

    var list = response.split("\n");

    for (var i = 0; i < list.length - 1; i++) {
        var s = list[i].split(";");
        bouquetSelector.addItem(s[1], s[0]);
    }

    bouquetSelector.sort();
}

function loadChannels(bouquet) {
    channelListView.clear();
    loadServices(bouquet, "populateChannelList");
}

function loadAllChannels() {
    channelListView.clear();
    loadServices(services["All services (TV)"], "populateChannelList");
}

function populateChannelList(response) {
    var list = response.split("\n");

    for (var i = 0; i < list.length - 1; i++) {
        var s = list[i].split(";");
        channelListView.addItem(s[1], s[0]);
    }

    channelListView.sort();
}

function switchChannel(xy) {
    http.get(ipaddress + "/cgi-bin/zapTo?path=" + xy);
}

function getEPG(ref) {
    http.get(ipaddress + '/getcurrentepg?type=extended' + (ref ? "&ref=" + ref : ""), {}, "loadInfo");
}

function getMultiEPG(ref) {
    http.get(ipaddress + '/getMultiEPG?ref=' + ref, {}, "loadInfo");
}

function getStreamInfo() {
    http.get(ipaddress + "/cgi-bin/streaminfo", {}, "loadInfo");
}

function getChannelInfo() {
    http.get(ipaddress + "/cgi-bin/channelinfo", {}, "loadInfo");
}

function loadInfo(info) {
    infoLabel.text = info;
    infoDialog.open();
}

function DVRrecord(command) {
    http.get(ipaddress + "/cgi-bin/videocontrol?command=" + command);
}

function sendMessageToTV(message) {
    http.get(ipaddress + "/cgi-bin/message?message=" + message);
    messageField.clear();
}

function getScreenShot() {
    screenshotImage.source = "";
    http.get(ipaddress + "/body?mode=controlScreenShot", {}, "loadScreenShot");
}

function loadScreenShot(response) {
    var ratio = response.match(/\d+:\d+/)[0].split(":");

    if (ratio.length === 2) {
        screenshotImage.height = Math.floor(screenshotImage.width * (parseInt(ratio[1]) / parseInt(ratio[0])));
    }

    screenshotImage.source = ipaddress + "/root/tmp/screenshot.bmp";
}

if (ipaddress) {
    loadServices("0", "populateServices");
}
