/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef BLUETOOTH_H
#define BLUETOOTH_H

#include <QObject>
#include <QScriptable>

class BluetoothPrivate;

class Bluetooth : public QObject, public QScriptable
{
    Q_OBJECT

public:
    explicit Bluetooth(QObject *parent = 0);
    ~Bluetooth();

    inline static Bluetooth* instance() { return self; }

public slots:
    void discoverDevices();

private:
    Bluetooth(BluetoothPrivate &dd, QObject *parent = 0);

    QScopedPointer<BluetoothPrivate> d_ptr;

    static Bluetooth *self;

    Q_DISABLE_COPY(Bluetooth)
    Q_DECLARE_PRIVATE(Bluetooth)

    Q_PRIVATE_SLOT(d_func(), void _q_onDeviceDiscoveryFinished())
};

#endif // BLUETOOTH_H
