#include "noremotewidget.h"
#include "../base/definitions.h"
#include <QPainter>
#include <QPaintEvent>

NoRemoteWidget::NoRemoteWidget(QWidget *parent) :
    QWidget(parent)
{
}

NoRemoteWidget::~NoRemoteWidget() {}

void NoRemoteWidget::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    QString title("MultiMote " + VERSION_NUMBER);
    QString description(tr("No remote loaded. Please choose a remote from the menu."));

    QFont bold;
    bold.setBold(true);
    bold.setPixelSize(52);

    QSize titleSize = QFontMetrics(bold).size(Qt::TextSingleLine, title);
    QSize descriptionSize = this->fontMetrics().size(Qt::TextSingleLine, description);
    QSize totalSize(qMax(titleSize.width(), descriptionSize.width()), 74 + descriptionSize.height());
    QRect content(this->rect().right() / 2 - totalSize.width() / 2, this->rect().bottom() / 2 - totalSize.height() / 2, totalSize.width(), totalSize.height());

    painter.drawPixmap(content.left(), content.top(), QPixmap("/usr/share/icons/hicolor/64x64/apps/multimote.png"));
    painter.save();
    painter.setFont(bold);
    painter.drawText(content.left() + 74, content.top(), titleSize.width(), titleSize.height(), Qt::AlignVCenter, title);
    painter.restore();
    painter.drawText(content.left(), content.top() + 74, descriptionSize.width(), descriptionSize.height(), Qt::AlignBottom, description);

    event->accept();
}
