/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "listview.h"
#include <QStandardItemModel>
#include <QStandardItem>

ListView::ListView(QWidget *parent) :
    QListView(parent),
    m_model(new QStandardItemModel(this))
{
    this->setContextMenuPolicy(Qt::ActionsContextMenu);
    this->setModel(m_model);
    this->connect(this, SIGNAL(activated(QModelIndex)), this, SLOT(onCurrentItemChanged()));
}

void ListView::onCurrentItemChanged() {
    emit currentItemChanged(this->currentItem());
}

void ListView::addItem(const QString &text, const QVariant &data) {
    QStandardItem *item = new QStandardItem(text);
    item->setData(data);
    m_model->appendRow(item);
}

bool ListView::removeItem(int row) {
    return m_model->removeRow(row);
}

void ListView::clear() {
    m_model->clear();
}

void ListView::sort(Qt::SortOrder order) {
    m_model->sort(0, order);
}

QStandardItem* ListView::itemAt(int row) const {
    return m_model->item(row);
}

QStandardItem* ListView::currentItem() const {
    return m_model->itemFromIndex(this->currentIndex());
}

int ListView::currentRow() const {
    return this->currentIndex().row();
}

void ListView::setCurrentRow(int row) {
    this->setCurrentIndex(m_model->index(row, 0));
}
