TEMPLATE = app
TARGET = multimote

QT += script xml

HEADERS += $$files(src/base/*.h) \
    $$files(src/controls/*.h) \
    $$files(src/prototypes/*.h)
SOURCES += $$files(src/base/*.cpp) \
    $$files(src/controls/*.cpp) \
    $$files(src/prototypes/*.cpp)

DEFINES += HTTP_PROTOCOL

maemo5 {
    QT += maemo5 dbus
    HEADERS += $$files(src/maemo5/*.h) \
        $$files(src/controls/widgets/*.h)
    SOURCES += $$files(src/maemo5/*.cpp) \
        $$files(src/controls/widgets/*.cpp)

    desktop.files = desktop/maemo5/multimote.desktop
    desktop.path = /usr/share/applications/hildon

    icon.files = desktop/maemo5/64x64/multimote.png
    icon.path = /usr/share/icons/hicolor/64x64/apps

    INSTALLS += desktop icon

} else:contains(MEEGO_EDITION,harmattan) {
    HEADERS += $$files(src/harmattan/*.h)
    SOURCES += $$files(src/harmattan/*.cpp)
}

contains(DEFINES,BT_PROTOCOL) {
    maemo5 {
        CONFIG += mobility12
    } else {
        CONFIG += mobility
    }

    MOBILITY += connectivity
    HEADERS += $$files(src/protocols/bluetooth/*.h)
    SOURCES += $$files(src/protocols/bluetooth/*.cpp)
}

contains(DEFINES,HTTP_PROTOCOL) {
    QT += network
    HEADERS += $$files(src/protocols/http/*.h)
    SOURCES += $$files(src/protocols/http/*.cpp)
}

contains(DEFINES,IR_PROTOCOL) {
    HEADERS += $$files(src/protocols/infrared/*.h)
    SOURCES += $$files(src/protocols/infrared/*.cpp)
}

unix {
    target.path = /opt/multimote/bin
}

INSTALLS += target
