#ifndef PLAYERSHEET_H
#define PLAYERSHEET_H

#include <QWidget>
#include <QGesture>
#include <QGestureEvent>

namespace Ui {
    class PlayerSheet;
}

class PlayerSheet : public QWidget
{
    Q_OBJECT

public:
    explicit PlayerSheet(QWidget *parent = 0);
    void SetPlayerName(QString name);
    ~PlayerSheet();
    void Reset();

signals:
    void closeSheetSignal(PlayerSheet*);

private:
    Ui::PlayerSheet *ui;    
    virtual bool event(QEvent *event);
    bool gestureEvent(QGestureEvent *event);
    void tapAndHoldTriggered(QSwipeGesture *gesture);

private slots:
    void closeSheet();
    void increaseLife1();
    void reduceLife1();
    void increaseLife5();
    void reduceLife5();    
};

#endif // PLAYERSHEET_H
