#ifndef CHANNELSREADER_H
#define CHANNELSREADER_H

#include <QObject>
#include <QXmlStreamReader>
#include <QByteArray>

#include "msomachannels.h"

class ChannelsReader : public QObject
{
    Q_OBJECT
public:
    explicit ChannelsReader(QObject *parent = 0);

    /**
      * Reads the contents of the specified file
      * @return false if the file could not be opened
      */
    bool readFile(const QString &file);
    const QByteArray &getReadData() const { return data; }

    void setData(const char *data);

    void addData(const QByteArray &d);

    void clearData() { data.clear(); }

    const MSomaChannels getChannels() const { return mSomaChannels; }

    const MSomaChannels readChannels();

private:
    QXmlStreamReader xml;
    QByteArray data;
    MSomaChannels mSomaChannels;

signals:

public slots:

};

#endif // CHANNELSREADER_H
