#ifndef QMESSAGELISTMODEL_H
#define QMESSAGELISTMODEL_H

#include <QAbstractListModel>
#include <datatypes/message.h>
#include <datatypes/friend.h>

class QMessageListModel : public QAbstractListModel
{
    Q_OBJECT
public:
    enum { SortRole = Qt::UserRole + 1 };

    explicit QMessageListModel(QObject *parent = 0):
        QAbstractListModel(parent) {}

    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role = Qt::DisplayRole) const;

    QModelIndex getIndex(const Message& msg) const;
    QModelIndex getIndex(int column, const Message& msg) const;
    QModelIndex getIndex(const QString& accountId, const QString& messageId) const;

    void setMessagesList(MessageList &list);

    // the whole list of messages
    MessageList msgList;

public slots:
    void updateList(const MessageList &list);
    void readMessage(const QString &accountId, const QString &messageId);

signals:
    void messageCountChanged(int newCount);

private:
    MessageList shownMessagesList;
};

#endif // QMESSAGELISTMODEL_H
