%define revision 1

Name:       msaqtwidgets
Summary:    MySocials UI items for social network clients
Version:    1.0.3
Release:    %{revision}
Group:      Development/Libraries
License:    GPL
URL:        http://oss.fruct.org/wiki/MySocials
Source0:    %{name}_%{version}-%{revision}.tar.gz
Source100: %{name}-rpmlintrc
BuildRoot:  %{_tmppath}/%{name}-root
 
%if 0%{?suse_version}  
BuildRequires:  libqt4-devel >= 4.6.0  
BuildRequires:  libqt4-devel-doc
BuildRequires:  libQtWebKit-devel
#Requires:       libQtWebKit4
Requires:       libqt4 >= 4.6.0
%endif  

%if 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  qt4-devel >= 4.6.0
BuildRequires:  qt4-devel-doc
BuildRequires:  gcc-c++
Requires:       qt4 >= 4.6.0
%endif

%if 0%{?mdkversion}
BuildRequires:  qt4-devel >= 4.6.0
BuildRequires:  qt4-assistant
BuildRequires:  gcc-c++
Requires:       qt4-common >= 4.6.0
%endif

%if 0%{?fedora_version}
%if 0%{?fedora_version} < 14
BuildRequires:  qt-devel >= 4.6.0
#BuildRequires:  libQtWebKit-devel
%else
BuildRequires:  qt4-devel >= 4.6.0
BuildRequires:  qt-webkit-devel
%endif
BuildRequires:  gcc-c++
Requires:       qt4-x11 >= 4.6.0
Requires:       qt4 >= 4.6.0
%endif

%if "0%{?meego_version}" != "0"
BuildRequires:  libqt-devel
BuildRequires:  qt-devel-tools
BuildRequires:  libqtwebkit-devel
Requires:       qt
%endif

BuildRequires:  mysocials-core-devel >= 1.3.2
Requires:  mysocials-core >= 1.3.2

BuildRequires:  doxygen

AutoReqProv:    1
#Requires(post):
 
%description
MySocials is a client to access services of social networks from desktop or mobile platform.
The MySocials core provides a Qt library to easy access to MySocials project functions.
The data from requests store into cache and can be requested iteratively.
 
%package devel
Group:          Development/Libraries 
Summary:        Headers and libraries of Qt core library for social network clients
Requires:       %{name} = %{version} 
Requires:       mysocials-dev >= 1.3.1

%description devel
MySocials is a client to access services of social networks from desktop or mobile platform.
The MySocials core provides a Qt library to easy access to MySocials project functions.
The package also includes necessary headers.

 
%prep
%setup -q -n %{name}-%{version}

./update_doc.sh
./update_translations.sh
 
# 01_disable_test.patch
#%patch0 -p1

%build
# >> build pre
export PATH=/usr/lib/qt4/bin:$PATH

%if 0%{?mdkversion} > 2006  
export PATH=/usr/lib/qt4/bin:$PATH  
export QTDIR=%{_prefix}/lib/qt4/  
%endif  

%if 0%{?fedora_version} || 0%{?centos_version}
qmake-qt4  PREFIX=%{_prefix}
%else
qmake PREFIX=%{_prefix}
%endif

%__make

%install
#rm -rf %{buildroot}
# >> install pre
# << install pre
 
 
export INSTALL_ROOT=%{buildroot} 
  
%if 0%{?mdkversion} || 0%{?fedora_version} < 13
make install
%else
# >> install post 
%make_install
# << install post
%endif
 
%post 
/sbin/ldconfig
 
%postun 
/sbin/ldconfig
 
%files
%defattr(-,root,root,-)
%{_libdir}/libmsaqtwidgets.so.*
%{_datadir}/qt4/translations/*.qm

%files devel
%defattr(-,root,root,-)
%{_libdir}/libmsaqtwidgets.so
%dir %{_includedir}/mysocials/qtwidgets
%{_includedir}/mysocials/qtwidgets/*.h
%dir %{_includedir}/mysocials/qtwidgets/utils
%{_includedir}/mysocials/qtwidgets/utils/*
%dir %{_includedir}/mysocials/qtwidgets/widgets
%{_includedir}/mysocials/qtwidgets/widgets/*
%dir %{_includedir}/mysocials/qtwidgets/panels
%{_includedir}/mysocials/qtwidgets/panels/*
%{_libdir}/pkgconfig/msaqtwidgets.pc
%dir %{_datadir}/doc/msaqtwidgets
%{_datadir}/doc/msaqtwidgets/*
%dir %{_datadir}/qt4/doc
%dir %{_datadir}/qt4/doc/qch
%{_datadir}/qt4/doc/qch/*

%changelog
