/*******************************************************************************
 * Copyright (c) 2009 Luca Donaggio.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* Includes */
#include <gtk/gtkmain.h>
#include <hildon/hildon.h>
#include <string.h>
#include <stdlib.h>
#include <glib/gfileutils.h>

#include "localisation.h"
#include "appdata.h"
#include "interface.h"
#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

int main(int argc,char* argv[]) {
    app_data_t *myapp;

    /* Initialize Hildon and GTK environments */
    hildon_gtk_init(&argc,&argv);
    /* Initialize application's data */
    myapp = app_init();
    /* Create application's UI */
    create_app(myapp);
    /* Begin the main application's loop */
    gtk_main();
    /* Exit */
    return 0;
}
