/*
 * Include declarations
 */
#include <libosso.h>
#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

#include "imgparam-window.h"

/*
 * Constants definitions
 */
#define MAXDIRLEN 512
#define MAXFNLEN 128
#define MINBUTPRESSTIME 1
#define MAXBUTPRESSDISTANCE 10
#define MCE_SIGNAL_MATCH "type='signal'," \
						 "sender='"    MCE_SERVICE     "'," \
						 "path='"      MCE_SIGNAL_PATH "'," \
						 "interface='" MCE_SIGNAL_IF   "'"
#define APP_DBUS_SERVICE "com.nokia." PACKAGE
#define APP_DBUS_OBJECT_PATH "com/nokia/" PACKAGE
#define APP_DBUS_INTERFACE "com.nokia." PACKAGE

/*
 * Program structure definition
 */
typedef enum {NONE,PREVIOUS,NEXT} action_t;

typedef enum {FIT_SCREEN,ONE_THIRD_RESOLUTION,HALF_RESOLUTION,FULL_RESOLUTION} zoom_t;

typedef struct app_data app_data_t;
struct app_data {
	osso_context_t* ossocont;
	DBusConnection* sysbus;
	HildonProgram* app;
	HildonWindow* mainwin;
	GtkWidget* image;
	GdkPixbuf* imgbuffer;
	ImgparamWindow* imgparamwin;
	gchar* imgparam;
	gchar* currfname;
	gchar* currdir;
	gint currfindex;
	GList* allimgindir;
	const gchar** rawext;
	glong pressbuttontime;
	gdouble pressbuttonx;
	gdouble pressbuttony;
	action_t actioninprog;
	zoom_t zoomlevel;
	gboolean showimgparam;
};

/*
 * Function definitons
 */
app_data_t* app_init();
void app_free(app_data_t *myapp);
