#include <stdlib.h>
#include <glib.h>
#include <libosso.h>

#include "appdata.h"
#include "helpers.h"
#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
/*
 * Initilize application's data structure
 */
app_data_t* app_init() {
    app_data_t *myapp;
	const gchar *myrawext[] = {"PEF","pef","DNG","dng","NEF","nef","ARW","arw","CR2","cr2","CRW","crw","RAF","raf","DCR","dcr","MRW","mrw","ORF","orf","SRF","srf","SR2","sr2","MOS","mos","TIF","tif",NULL};
	guint i;

	myapp = g_new(app_data_t,1);
    /* Initialize application's data structure */
    myapp->imgbuffer = NULL;
    myapp->allimgindir = NULL;
    myapp->currdir = NULL;
    myapp->currfname = NULL;
    myapp->currfindex = 0;
    myapp->imgparam = NULL;
    myapp->imgparamwin = NULL;
    myapp->pressbuttontime = 0;
    myapp->rawext = g_malloc(sizeof(myrawext));
	for(i = 0;myrawext[i] != NULL;i++) {
		myapp->rawext[i] = g_strdup(myrawext[i]);
	}
    myapp->actioninprog = NONE;
    myapp->zoomlevel = FIT_SCREEN;
    myapp->showimgparam = FALSE;

    /* Load configuration from GConf */
    load_configuration(myapp);

	/* Initialize OSSO context */
    myapp->ossocont = osso_initialize(PACKAGE,VERSION,TRUE,NULL);
	if (myapp->ossocont == NULL) {
		g_printerr("ERROR: OSSO context initialization failed\n");
    	exit(1);
    }

	return myapp;
}

/*
 * Free application data structure's allocated memory
 */
void app_free(app_data_t *myapp) {
	guint i;

	for(i = 0;myapp->rawext[i] != NULL;i++) g_free(myapp->rawext[i]);
    g_free(myapp->rawext);
    g_free(myapp);
}
