/*
 * Program structure definition
 */
typedef enum {NONE,PREVIOUS,NEXT} action_t;

typedef enum {FIT_SCREEN,ONE_THIRD_RESOLUTION,HALF_RESOLUTION,FULL_RESOLUTION} zoom_t;

typedef struct app_data app_data_t;
struct app_data {
	DBusConnection* sysbus;
	HildonProgram* app;
	HildonWindow* mainwin;
	GtkWidget* image;
	GdkPixbuf* imgbuffer;
	GtkWidget* imgparamwin;
	gchar* imgparam;
	gchar* currfname;
	gchar* currdir;
	gint currfindex;
	GList* allimgindir;
	const gchar** rawext;
	glong pressbuttontime;
	gdouble pressbuttonx;
	gdouble pressbuttony;
	action_t actioninprog;
	zoom_t zoomlevel;
};
/*
 * Functions declaration
 */
void create_app(app_data_t*);
void create_about(GtkWidget *callerobj,app_data_t *myapp);
void create_image_details(GtkWidget *callerobj,app_data_t *myapp);
