/*******************
 * Interface builder
 *******************/
/*
 * Include declarations
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

#include "interface.h"
#include "callbacks.h"

/*
 * Main application's window
 */
void create_app(app_data_t *myapp) {
	GtkWidget *openitem;
	GtkWidget *showimgdet;
	GtkWidget *hideimgdet;
	GtkWidget *aboutitem;
	GtkWidget *quititem;
	GtkWidget *previtem;
	GtkWidget *nextitem;
	GtkWidget *panarea;
    GtkWidget *eventbox;

    /* Create the hildon program and setup the title */
    myapp->app = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("RAW Viewer");

    /* Create HildonWindow and set it to HildonProgram */
    myapp->mainwin = HILDON_WINDOW(hildon_window_new());
    /* hildon_gtk_window_set_portrait_flags(window, HILDON_PORTRAIT_MODE_SUPPORT); */
    hildon_program_add_window(myapp->app, myapp->mainwin);

    /* Create the main menu */
    myapp->appmenu = HILDON_APP_MENU(hildon_app_menu_new());

    previtem = gtk_button_new_with_label("Previous image");
    gtk_widget_set_sensitive(previtem,FALSE);
    g_signal_connect_after(G_OBJECT (previtem),"clicked",G_CALLBACK(load_prev_image),myapp);
    hildon_app_menu_insert(myapp->appmenu,GTK_BUTTON(previtem),0);

    nextitem = gtk_button_new_with_label("Next image");
    gtk_widget_set_sensitive(nextitem,FALSE);
    g_signal_connect_after(G_OBJECT (nextitem),"clicked",G_CALLBACK(load_next_image),myapp);
    hildon_app_menu_insert(myapp->appmenu,GTK_BUTTON(nextitem),1);

    openitem = gtk_button_new_with_label("Open image");
    g_signal_connect_after(G_OBJECT (openitem),"clicked",G_CALLBACK(open_image_file),myapp);
    hildon_app_menu_insert(myapp->appmenu,GTK_BUTTON(openitem),2);

    aboutitem = gtk_button_new_with_label("About");
    g_signal_connect_after(G_OBJECT (aboutitem),"clicked",G_CALLBACK(create_about),myapp);
    hildon_app_menu_insert(myapp->appmenu,GTK_BUTTON(aboutitem),3);

    quititem = gtk_button_new_with_label("Quit");
    g_signal_connect_after(G_OBJECT (quititem),"clicked",G_CALLBACK(gtk_main_quit),myapp);
    hildon_app_menu_insert(myapp->appmenu,GTK_BUTTON(quititem),4);

    showimgdet = gtk_radio_button_new_with_label(NULL,"Show image details");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (showimgdet),FALSE);
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON (showimgdet),FALSE);
    hideimgdet = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (showimgdet),"Hide image details");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (hideimgdet),TRUE);
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON (hideimgdet),FALSE);
    g_signal_connect_after(G_OBJECT (showimgdet),"clicked",G_CALLBACK(show_image_details),myapp);
    g_signal_connect_after(G_OBJECT (hideimgdet),"clicked",G_CALLBACK(hide_image_details),myapp);
    hildon_app_menu_add_filter(myapp->appmenu,GTK_BUTTON (showimgdet));
    hildon_app_menu_add_filter(myapp->appmenu,GTK_BUTTON (hideimgdet));

    hildon_window_set_app_menu(HILDON_WINDOW(myapp->mainwin),myapp->appmenu);

	/* Add a pannable area with the image container inside */
    panarea = GTK_WIDGET(hildon_pannable_area_new());
    gtk_container_add(GTK_CONTAINER (myapp->mainwin),panarea);
    eventbox = gtk_event_box_new();
    gtk_widget_set_events(eventbox,GDK_BUTTON_PRESS || GDK_BUTTON_RELEASE || GDK_KEY_PRESS);
    myapp->image = GTK_WIDGET (gtk_image_new());
    gtk_container_add(GTK_CONTAINER (eventbox),myapp->image);
    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA (panarea),eventbox);
    hildon_pannable_area_set_size_request_policy(HILDON_PANNABLE_AREA (panarea),HILDON_SIZE_REQUEST_CHILDREN);

    /* Show everything */
    gtk_widget_show_all(GTK_WIDGET (myapp->mainwin));

    /*
     * Connect some signals
     */
    g_signal_connect(G_OBJECT (myapp->mainwin),"delete_event",
    		G_CALLBACK (gtk_main_quit),NULL);
    g_signal_connect(G_OBJECT (myapp->mainwin),"expose_event",
    		G_CALLBACK (detect_main_window_changes),myapp);
    g_signal_connect(G_OBJECT (eventbox),"button_press_event",
    		G_CALLBACK (detect_button_press_on_image),myapp);
    g_signal_connect(G_OBJECT (eventbox),"button_release_event",
        	G_CALLBACK (detect_button_press_on_image),myapp);
    g_signal_connect(G_OBJECT(myapp->mainwin),"key_press_event",
			G_CALLBACK (detect_hardware_key_press),myapp);

}
