#ifndef PRAYTIME_H
#define PRAYTIME_H

#include <QDateTime>
#include <QString>

class CalculationMethod {
        //fa : fajr angle
        float fajrAngle;
        //ms : maghrib selector (0 = angle; 1 = minutes after sunset)
        int maghribSelector;
        //mv : maghrib parameter value (in angle or minutes)
        float maghribParam;
        //is : isha selector (0 = angle; 1 = minutes after maghrib)
        int ishaSelector;
        //iv : isha parameter value (in angle or minutes)
        float ishaParam;

public:

        float getFajrAngle() {
                return fajrAngle;
        }

        int getMaghribSelector() {
                return maghribSelector;
        }

        float getMaghribParam() {
                return maghribParam;
        }

        int getIshaSelector() {
                return ishaSelector;
        }

        float getIshaParam() {
                return ishaParam;
        }

        void setParams(float fa, int ms, float mv, int is, float iv) {
                fajrAngle = fa;
                maghribSelector = ms;
                maghribParam = mv;
                ishaSelector = is;
                ishaParam = iv;
        }

        CalculationMethod() {
        }

        void setJafari() {
                setParams(16, 0, 4, 0, 14);
        }

        void setKarachi() {
                setParams(18, 1, 0, 0, 18);
        }

        void setIsna() {
                setParams(15, 1, 0, 0, 15);
        }

        void setMwl() {
                setParams(18, 1, 0, 0, 17);
        }

        void setMakkah() {
                setParams(19, 1, 0, 1, 90);
        }

        void setEgypt() {
                setParams(19.5, 1, 0, 0, 17.5);
        }

        void setTehran() {
                setParams(17.7, 0, 4.5, 0, 15);
        }
};

class PrayTime {
public:
PrayTime(int calcMethod, int juristicMethod, int latMethod, int timeFormat);
//~PrayTime();

float calcJD(int year, int month, int day);

//---------------------- Trigonometric Functions -----------------------

// degree sin
float dsin(float d);

// degree cos
float dcos(float d);

// degree tan
float dtan(float d);

// degree arcsin
float darcsin(float x);

// degree arccos
float darccos(float x);

// degree arctan
float darctan(float x);

// degree arctan2
float darctan2(float y, float x);

// degree arccot
float darccot(float x);

// degree to radian
float dtr(float d);

// radian to degree
float rtd(float r);
// range reduce angle in degrees.
float fixangle(float a);

// range reduce hours to 0..23
float fixhour(float a);

// set the calculation method
void setCalcMethod(int methodID);

// set the juristic method for Asr
void setAsrMethod(int methodID);

// set the minutes after mid-day for calculating Dhuhr
void setDhuhrMinutes(int minutes);

// set adjusting method for higher latitudes
void setHighLatsMethod(int methodID);

// set the time format
void setTimeFormat(int tFormat);

QString floatToString(float in);

// convert float hours to 24h format
QString floatToTime24(float time);

// convert float hours to 12h format
QString floatToTime12(float time, bool noSuffix);

// convert float hours to 12h format with no suffix
QString floatToTime12NS(float time);

// compute declination angle of sun and equation of time
float sunPosition(float jd, int index);

// compute equation of time
float equationOfTime(float jd);

// compute declination angle of sun
float sunDeclination(float jd);

//---------------------- Compute Prayer Times -----------------------

// convert hours to day portions
float * dayPortion(float times[]);

// compute mid-day (Dhuhr, Zawal) time
float computeMidDay(float t);

// compute time for a given angle G
float computeTime(float G, float t);

// compute the time of Asr
// Shafii: step=1, Hanafi: step=2
float computeAsr(int step, float t);

// compute prayer times at given julian date
void computeTimes(float times[]);

// adjust times in a prayer time array
void adjustTimes(float * array);

// convert times array to given time format
void adjustTimesFormat(float times[]);

// compute prayer times at given julian date
void computeDayTimes();

// adjust Fajr, Isha and Maghrib for locations in higher latitudes
float * adjustHighLatTimes(float times[]);

// the night portion used for adjusting times in higher latitudes
float nightPortion(float angle);

//---------------------- Misc Functions -----------------------


// compute the difference between two times
float timeDiff(float time1, float time2);

// add a leading 0 if necessary
QString twoDigitsFormat(float num);

//-------------------- Interface Functions --------------------

// return prayer times for a given date
void getDatePrayerTimes(int year, int month, int day, float latitude, float longitude, int tZ);

void getPrayerTimes(QDateTime dateTime, float latitude, float longitude, int timeZone);

QString * getPrayTimesArray();

};

#endif // PRAYTIME_H
