// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef THEATERSCHEDULEMODEL_H
#define THEATERSCHEDULEMODEL_H

#include "data/scheduleentrykey.h"
#include "data/cinema.h"
#include "data/movie.h"
#include "data/scheduleentry.h"

#include <QAbstractListModel>

class CinemaSchedule;

class TheaterScheduleModel : public QAbstractListModel
{
    Q_OBJECT
private:
    typedef QList<QDate> ScheduleDates;
    typedef QList<ScheduleEntryKey> ScheduleKeys;
public:
    enum {
        SortRole = Qt::UserRole,
        TheaterScheduleItemRole,
        TheaterScheduleKeyRole
    };
public:
    TheaterScheduleModel(const CinemaSchedule *, const CinemaKey &, QObject *parent = 0);

    void Update();

    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;

private:
    const CinemaSchedule *_cinema_schedule;
    CinemaKey _cinema_key;
    ScheduleDates _schedule_dates;
    ScheduleKeys _schedule_keys;
};

#endif // THEATERSCHEDULEMODEL_H
