// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef BACKGROUNDLABEL_H
#define BACKGROUNDLABEL_H

#include <QWidget>

class BackgroundLabel : public QWidget
{
    Q_OBJECT
public:
    BackgroundLabel(QWidget *parent);

public slots:
    void SetLabelText(const QString &label_text);

protected:
    void paintEvent(QPaintEvent *event);

private:
    QString _label_text;
    QRect _cached_widget_rect;
    QRect _cached_label_rect;
    int _cached_label_font_size;
    Qt::Alignment _cached_label_alignment;
};

#endif // BACKGROUNDLABEL_H
