// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef LOCATIONDIALOG_H
#define LOCATIONDIALOG_H

#include "data/location.h"

#include <QDialog>
#include <QList>
#include <QVector>

class QPushButton;

namespace Ui {
    class LocationDialog;
}

class LocationDialog : public QDialog {
    Q_OBJECT

public:
    typedef QList<Location> Locations;

public:
    explicit LocationDialog(QWidget *parent = 0);
    ~LocationDialog();

    void SetLocation(const Location &location);

    void SetPreviousLocations(const Locations &);

    void SetGPSEnabled(bool gps_enabled);

    void show();

public:
    Q_SIGNAL void Search(Location location);
    Q_SIGNAL void SearchPreviousLocation(Location location);
    Q_SIGNAL void SearchGPS();
    Q_SIGNAL void Cancel();

private:
    Q_SLOT void SearchClicked();
    Q_SLOT void GPSClicked();
    Q_SLOT void PreviousLocation1Clicked();
    Q_SLOT void PreviousLocation2Clicked();
    Q_SLOT void PreviousLocation3Clicked();
    Q_SLOT void PreviousLocation4Clicked();
    Q_SLOT void PreviousLocation5Clicked();

    Q_SLOT void Rotate();

private:
    void PreviousLocationClicked(int i);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::LocationDialog *ui;
    Locations _previous_locations;
    QVector<QPushButton *> _location_buttons;
};

#endif // LOCATIONDIALOG_H
