// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "daypainter.h"
#include "utils/timeutils.h"
#include "ui/styleutils.h"

#include <QPainter>
#include <QStyleOptionViewItem>
#include <QDate>

DayPainter::DayPainter()
{
}

void DayPainter::Paint(QPainter *painter, const QStyleOptionViewItem &option, const QDate &date) const
{
    QString date_name = TimeUtils::ToDateString(date);
    QFont bigfont(option.font);
    bigfont.setPointSizeF(bigfont.pointSizeF() * 1.5);
    painter->setFont(bigfont);
    QRectF text_rect = painter->boundingRect(option.rect, Qt::AlignCenter, date_name);
    text_rect.setWidth(text_rect.width() + 16);
    painter->setPen(Qt::NoPen);
    painter->setBrush(StyleUtils::INSTANCE()->GetDayBackgroundColor(option.palette, date));
    painter->drawRoundedRect(32, 2, text_rect.width(), text_rect.height(), 5, 5);
    painter->setPen(StyleUtils::INSTANCE()->GetDayTextColor(option.palette, date));
    painter->drawText(32, 2, text_rect.width(), text_rect.height(), Qt::AlignCenter, date_name);
}

QSize DayPainter::GetSizeHint(const QStyleOptionViewItem &option) const
{
    return QSize(0, option.fontMetrics.height() * 1.5 + 4);
}
