// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "cinemapainter.h"

#include "data/cinema.h"
#include "ui/styleutils.h"

#include <QPainter>
#include <QStyleOptionViewItem>

CinemaPainter::CinemaPainter()
{
}

void CinemaPainter::Paint(QPainter *painter, const QStyleOptionViewItem &option, const Cinema *cinema) const
{
    painter->setFont(option.font);
    painter->setPen(StyleUtils::INSTANCE()->GetColor(option.palette, StyleUtils::DefaultTextColor));
    painter->drawText(0, painter->fontMetrics().ascent(), cinema->GetName());
    int y = painter->fontMetrics().height() + 2;
    QRect bounding_rect;
    painter->setPen(StyleUtils::INSTANCE()->GetColor(option.palette, StyleUtils::SecondaryTextColor));
    bool drawn = false;
    if (!cinema->GetAddress().isEmpty()) {
        QFont font2(option.font);
        font2.setPointSizeF(font2.pointSizeF() * 0.7);
        painter->setFont(font2);
        painter->drawText(0, y, 1000, painter->fontMetrics().height(),
                          0, cinema->GetAddress(), &bounding_rect);
        drawn = true;
    }
    if (!cinema->GetTelephone().isEmpty()) {
        painter->drawText(bounding_rect.right(), y, 1000, painter->fontMetrics().height(),
                          0, QString((drawn ? ", %1" : "%1")).arg(cinema->GetTelephone()), &bounding_rect);
    }
}

QSize CinemaPainter::GetSizeHint(const QStyleOptionViewItem &option) const
{
    return QSize(0, option.fontMetrics.height() + 2 + option.fontMetrics.height() * 0.7 + 4);
}
