// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "scheduleentryitem.h"

ScheduleEntryItem::ScheduleEntryItem() :
        _is_schedule_date_item(false)
{
}

ScheduleEntryItem::ScheduleEntryItem(QDate schedule_date) :
        _is_schedule_date_item(true),
        _schedule_date(schedule_date)
{
}

ScheduleEntryItem::ScheduleEntryItem(const ScheduleEntry &schedule_entry) :
        _is_schedule_date_item(false),
        _schedule_entry(schedule_entry),
        _movie(*schedule_entry.GetMovie()),
        _cinema(*schedule_entry.GetCinema())
{
    _schedule_entry.SetMovie(&_movie);
    _schedule_entry.SetCinema(&_cinema);
}

ScheduleEntryItem::ScheduleEntryItem(const ScheduleEntryItem &rhs) :
        _is_schedule_date_item(rhs._is_schedule_date_item),
        _schedule_date(rhs._schedule_date),
        _schedule_entry(rhs._schedule_entry),
        _movie(rhs._movie),
        _cinema(rhs._cinema)
{
    _schedule_entry.SetMovie(&_movie);
    _schedule_entry.SetCinema(&_cinema);
}

ScheduleEntryItem &ScheduleEntryItem::operator= (const ScheduleEntryItem &rhs)
{
    if (this != &rhs) {
        _is_schedule_date_item = rhs._is_schedule_date_item;
        _schedule_date = rhs._schedule_date;
        _schedule_entry = rhs._schedule_entry;
        _movie = rhs._movie;
        _cinema = rhs._cinema;
        _schedule_entry.SetMovie(&_movie);
        _schedule_entry.SetCinema(&_cinema);
    }
    return *this;
}
