// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef GPSCLIENT_H
#define GPSCLIENT_H

#include "searchclientsemaphore.h"

#include <QObject>
#include <QMutex>
#include <QNetworkReply>

class QNetworkAccessManager;

#ifdef QT_MOBILITY_LOCATION
#include <qmobilityglobal.h>

QTM_BEGIN_NAMESPACE
        class QGeoPositionInfo;
class QGeoPositionInfoSource;
QTM_END_NAMESPACE;

QTM_USE_NAMESPACE;
#endif

#ifdef LIBLOCATION
extern "C" {
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
}
class QTimer;
#endif

class GpsClient : public QObject
{
    Q_OBJECT
public:
    static const int INVALID_SEARCH_TASK_ID = -1;

public:
    GpsClient();
    ~GpsClient();

public:
    int GetSearchTaskId() const { return _search_task_id; }

    void SearchLocation();

    static void CancelAllRunningSearchs();

public:
    Q_SIGNAL void SearchStarted(int search_task_id);
    Q_SIGNAL void PositionUpdate(int search_task_id);
    Q_SIGNAL void SearchForTownStarted(int search_task_id);
    Q_SIGNAL void TownUpdate(int search_task_id, QString town);
    Q_SIGNAL void SearchError(int search_task_id);
    Q_SIGNAL void SearchFinished(int search_task_id, bool success);

private:
#ifdef QT_MOBILITY_LOCATION
    Q_SLOT void GeoPositionUpdated(const QGeoPositionInfo &);
    Q_SLOT void GeoPositionTimedOut();
#endif

#ifdef LIBLOCATION
public:
    void GpsConnected();
    void GpsChanged();
    void GpsDisconnected();
    Q_SLOT void GpsTimedOut();
#endif

private:
    void SearchTown(const QString &longitude, const QString &latitude);
    Q_SLOT void ReplyFinished(QNetworkReply *);
    Q_SLOT void NetworkError(QNetworkReply::NetworkError);

private:
#ifdef QT_MOBILITY_LOCATION
    QGeoPositionInfoSource *_geo_position_info_source;
#endif

#ifdef LIBLOCATION
    LocationGPSDControl *_location_gpsd_control;
    LocationGPSDevice *_location_gps_device;
    QTimer *_time_out_timer;
#endif

    QNetworkAccessManager *_network;
    static QMutex _next_search_task_id_mutex;
    static int _next_search_task_id;
    int _search_task_id;
    static SearchClientSemaphore _semaphore;
};

#endif // GPSCLIENT_H
