// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "ratingprovider.h"

#include <QPixmap>

RatingProvider::RatingProvider()
{
    _instance = this;
}

void RatingProvider::Load()
{
    /*
      The files loaded here are created from files in svg format under license
      Creative Commons Attribution-Share Alike 2.5 Generic from author "Andreas 06"
      on commons.wikimedia.org/wiki.
     */
    _rating_stars.reserve(11);
    for (int i = 0; i < 10; ++i) {
        _rating_stars.append(QPixmap(QString(":/resources/%1.png").arg(i)));
    }
}

QPixmap RatingProvider::GetRating(double percentage)
{
    if (percentage < 0.0 || percentage > 1.0) {
        return QPixmap();
    }
    return _rating_stars[(int) (percentage * 10.0)];
}

RatingProvider *RatingProvider::_instance;

RatingSingleton::RatingSingleton()
{
    _instance.Load();
}
