// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SCHEDULEENTRY_H
#define SCHEDULEENTRY_H

#include "scheduleentrykey.h"

#include <QString>
#include <QDate>

class Cinema;
class Movie;

class ScheduleEntry
{
public:
    ScheduleEntry();
    ScheduleEntry(const Cinema *cinema, const Movie *movie, const QTime &start_time, const QDate &date);

    ScheduleEntryKey GetKey() const;

    bool IsValid() const { return _cinema != 0 && _movie != 0; }

    const Cinema *GetCinema() const { return _cinema; }
    void SetCinema(const Cinema *cinema) { _cinema = cinema; }

    const Movie *GetMovie() const { return _movie; }
    void SetMovie(const Movie *movie) { _movie = movie; }

    QTime GetStartTime() const { return _start_time; }
    void SetStartTime(const QTime &start_time) { _start_time = start_time; }

    QDate GetDate() const { return _date; }
    void SetDate(const QDate &date) { _date = date; }

private:
    const Cinema *_cinema;
    const Movie *_movie;
    QTime _start_time;
    QDate _date;
};

bool operator==(const ScheduleEntry &lhs, const ScheduleEntry &rhs);

uint qHash(const ScheduleEntry &);

#endif // SCHEDULEENTRY_H
