// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "scheduleentrykey.h"

#include <qhash.h>

ScheduleEntryKey::ScheduleEntryKey(const CinemaKey &cinema_key, const MovieKey &movie_key, const QTime &start_time, const QDate &date) :
        _cinema_key(cinema_key),
        _movie_key(movie_key),
        _start_time(start_time),
        _date(date)
{
}

bool operator==(const ScheduleEntryKey &lhs, const ScheduleEntryKey &rhs)
{
    return lhs.GetCinemaKey() == rhs.GetCinemaKey()
            && lhs.GetMovieKey() == rhs.GetMovieKey()
            && lhs.GetStartTime() == rhs.GetStartTime()
            && lhs.GetDate() == rhs.GetDate();
}

uint qHash(const ScheduleEntryKey &key)
{
    static QTime midnight(0, 0);
    return qHash(key.GetCinemaKey()) + qHash(key.GetMovieKey()) + qHash(-key.GetStartTime().secsTo(midnight)) + qHash(key.GetDate().toJulianDay());
}
