// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CONNECTIVITYMANAGER_H
#define CONNECTIVITYMANAGER_H

#include <QObject>
#include <QDBusConnection>

class QDBusMessage;
class QDBusInterface;

class ConnectivityManager : public QObject
{
    Q_OBJECT
public:
    explicit ConnectivityManager(QObject *parent = 0);
    ~ConnectivityManager();

public:
    Q_SLOT void Connect();
    Q_SLOT void Disconnect();
    Q_SLOT void UpdateConnectionState();

public:
    Q_SIGNAL void Connected();
    Q_SIGNAL void Disconnected();
    Q_SIGNAL void Error();

private:
    Q_SLOT void StatisticsSentResult(const QDBusMessage& rep);
    Q_SLOT void ChangeState(const QDBusMessage& rep);

private:
    QDBusConnection _dbus_connection;
    QDBusInterface *_interface;
};

#endif // CONNECTIVITYMANAGER_H
