// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "theaterdelegate.h"

#include "theatermodel.h"
#include "data/cinema.h"

#include <QPainter>

TheaterDelegate::TheaterDelegate(QWidget *parent)
    : QStyledItemDelegate(parent)
{
}

void TheaterDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                            const QModelIndex &index) const
{
    if (qVariantCanConvert<TheaterItem>(index.data())) {
        TheaterItem item = qVariantValue<TheaterItem>(index.data());
        painter->save();
        painter->translate(option.rect.x(), option.rect.y());
        _cinema_painter.Paint(painter, option, item.GetCinema());
        painter->restore();
    } else {
        QStyledItemDelegate::paint(painter, option, index);
    }
}

QSize TheaterDelegate::sizeHint(const QStyleOptionViewItem &option,
                                const QModelIndex &index) const
{
    if (qVariantCanConvert<TheaterItem>(index.data())) {
        return _cinema_painter.GetSizeHint(option);
    } else {
        return QStyledItemDelegate::sizeHint(option, index);
    }
}
