/*  vibro.c
 *
 *  Vibro feedback routines
 *
 *  (c) 2009 Anton Olkhovik <ant007h@gmail.com>
 *
 *  This file is part of Mokomaze - labyrinth game.
 *
 *  Mokomaze is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Mokomaze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Mokomaze.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#include <dbus/dbus.h>
#include "vibro.h"

FILE* fvibro = NULL;
SDL_TimerID vibro_timer = 0;

int GetVibroInterval();

DBusConnection* conn;
int init_vibro() {
    DBusError err;
    // initialise the errors
    dbus_error_init(&err);

    // connect to the bus
    conn = dbus_bus_get(DBUS_BUS_SYSTEM, &err);
    if (dbus_error_is_set(&err)) {
        fprintf(stderr, "Connection to DBUS error (%s)\n", err.message);
        dbus_error_free(&err);
    }
    if (NULL == conn) {
        return 1;
    }

    return 0;
}

int vibra_error = 0;


int set_vibro(BYTE level) {
    if (vibra_error != 0) {
        return 0;
    }

    level /= 3;
    if (level < 20) {
        level = 20;
    }

    DBusMessage* msg;

    // create a signal and check for errors
    msg = dbus_message_new_method_call("com.nokia.mce", //dest
            "/com/nokia/mce/request", // path
            "com.nokia.mce.request", // interface
            "req_start_manual_vibration"); // method str
    if (NULL == msg) {
        fprintf(stderr, "Message Null\n");
        exit(1);
    }

    int speed = 70;
    int level2 = level;

    // append arguments onto signal
    if (!dbus_message_append_args(msg, DBUS_TYPE_INT32, &speed, DBUS_TYPE_INT32, &level2)) {
        fprintf(stderr, "Out Of Memory!\n");
        exit(1);
    }
//    if (!dbus_message_iter_append_basic(&args, DBUS_TYPE_INT32, &level2)) {
//        fprintf(stderr, "Out Of Memory!\n");
//        exit(1);
//    }

    DBusPendingCall* pending;
    // send the message and flush the connection
    if (!dbus_connection_send_with_reply(conn, msg, &pending, 10)) { // -1 is default timeout
        fprintf(stderr, "Out Of Memory!\n");
        exit(1);
    }
    if (NULL == pending) {
        fprintf(stderr, "Pending Call Null\n");
        exit(1);
    }
    dbus_connection_flush(conn);
    // free the message
    dbus_message_unref(msg);

    // block until we receive a reply
    dbus_pending_call_block(pending);

    // get the reply message
    msg = dbus_pending_call_steal_reply(pending);
    if (NULL == msg) {
        fprintf(stderr, "Reply Null\n");
        exit(1);
    }
    // free the pending message handle
    dbus_pending_call_unref(pending);

    // free reply and close connection
    dbus_message_unref(msg);

    return 0;
}

int close_vibro() {
    return 0;
}

