#!/usr/bin/run-standalone.sh python2.5

import dbus, gtk, hildon, helpers
# Try to load one gconf implementation, preferring python-gconf over gnome-python
for gconf_module in ('gconf', 'gnome.gconf'):
    try:
        gconf = __import__(gconf_module)
        break
    except:
        pass

from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)


class hotspot_frontend:
    def __init__(self):
        # Setup DBUS and GConf
        self.gc = gconf.Client()
        self.bus = dbus.SystemBus()
        self.icd2_obj = self.bus.get_object('com.nokia.icd2', '/com/nokia/icd2')
        self.icd2_iface = dbus.Interface(self.icd2_obj, 'com.nokia.icd2')
        # For some reason this seems not to work
        self.mce_obj = self.bus.get_object('com.nokia.mce.signal', '/com/nokia/mce/signal')
        self.mce_obj.connect_to_signal('sig_device_mode_ind', self.mce_signal_listener, 'com.nokia.mce.signal')
        # TODO: Attach also to the icd status_changed messages so we can shutdown the backend if disconnect is requested

        # Basic properties
        self.backend_started = False


        # Initialize the main window
        self.program = hildon.Program.get_instance()
        self.mainwindow = hildon.StackableWindow()
        self.program.add_window(self.mainwindow)
        self.mainwindow.connect('delete_event', self.quit, None)
        self.mainwindow.set_title('Mobile HotSpot')
        
        # Divive window to left and right halves which are vboxes        
        hbox = gtk.HBox(homogeneous=True)
        self.main_left_column = gtk.VBox()
        hbox.add(self.main_left_column)
        self.main_right_column = gtk.VBox()
        hbox.add(self.main_right_column)
        self.mainwindow.add(hbox)

        # Start/stop button 
        self.startstop_button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        #self.startstop_button = gtk.Button('')
        self.startstop_button.connect('clicked', self.startstop_clicked)
#        self.startstop_eb = gtk.EventBox()
#        self.startstop_eb.add(self.startstop_button)
#        self.main_left_column.pack_end(self.startstop_eb)
        self.main_left_column.pack_end(self.startstop_button)
        self.update_startstop_state()

        # NPK
        # Interface selection picker button 
        self.if_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.if_picker_button.set_title('Interface')
        self.if_selector = hildon.TouchSelector(text=True)
        self.if_selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        self.if_selector.append_text('WLAN')
        self.if_selector.append_text('USB')
        self.if_picker_button.set_selector(self.if_selector)
        self.current_interface_name = self.gc.get_string('/apps/mobilehotspot/interface_name')
        for k, interface in enumerate(self.if_selector.get_model(0)):
            if interface[0] == self.current_interface_name:
                self.if_picker_button.set_active(k)
        self.if_picker_button.connect('value-changed', self.save_interface)
        self.main_left_column.pack_end(self.if_picker_button)

        # Connection picker
        self.connection_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.connection_picker_button.set_title('Connection')
        self.connection_selector = hildon.TouchSelector(text=True)
        self.connection_selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        self.update_connection_list()
        self.connection_picker_button.set_selector(self.connection_selector)
        self.connection_picker_button.connect('value-changed', self.save_connection)
        self.connection_picker_button.connect('pressed', self.update_connection_list)
        self.main_right_column.add(self.connection_picker_button)

        # SSID
        self.ssid_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.ssid_button.set_title('Network name')
        self.ssid_selector = hildon.TouchSelectorEntry(text=True)
        ssid = self.gc.get_string('/apps/mobilehotspot/ssid')
        if ssid == None:
            ssid = 'MobileHotSpot'
        self.ssid_selector.append_text(ssid)
        self.ssid_button.set_selector(self.ssid_selector)
        self.ssid_button.set_active(0)
        self.ssid_button.connect('value-changed', self.save_ssid)
        self.main_right_column.add(self.ssid_button)
        
        # Encryption
        self.encryption_button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.encryption_button.set_title('Encryption')
        if self.gc.get_string('/apps/mobilehotspot/encryption_algo') == None:
            self.encryption_button.set_value('None')
        else:
            self.encryption_button.set_value('WEP')
        self.encryption_button.connect('clicked', self.encryption_clicked)
        self.main_right_column.pack_end(self.encryption_button)
        
    def save_encryption(self, button, *args):
        if self.cb_wep.get_active():
            self.gc.set_string('/apps/mobilehotspot/encryption_algo', 'WEP')
            self.gc.set_string('/apps/mobilehotspot/encryption_key', helpers.verify_wep_key(self.entry_key.get_text()))
            self.encryption_button.set_value('WEP')
        else:
            self.gc.unset('/apps/mobilehotspot/encryption_algo')
            self.encryption_button.set_value('None')
        self.encryption_dialog.hide()
    
    def save_ssid(self, button, *args):
        """Called via ssid_button, saves the current value"""
        # TODO: Figure out how to validate the result
        self.gc.set_string('/apps/mobilehotspot/ssid', button.get_value())
    
    def encryption_clicked(self, *args):
        """Shows the encryption selection dialog"""
        self.encryption_dialog = gtk.Dialog()
        self.encryption_dialog.set_transient_for(self.mainwindow)
        self.encryption_dialog.set_title("Select encryption method")
        self.cb_wep = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.cb_wep.set_label("Enable WEP-Encryption")
        self.cb_wep.set_active(self.gc.get_string('/apps/mobilehotspot/encryption_algo') != None)
        self.cb_wep.connect("toggled", self.cb_wep_toggled)
        self.encryption_dialog.vbox.add(self.cb_wep)
        self.entry_key = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.entry_key.set_placeholder("WEP-Key")
        if self.gc.get_string('/apps/mobilehotspot/encryption_key') != None:
            self.entry_key.set_text(helpers.verify_wep_key(self.gc.get_string('/apps/mobilehotspot/encryption_key')))
        self.entry_key.set_sensitive(self.cb_wep.get_active())
        self.encryption_dialog.vbox.add(self.entry_key)
        self.encryption_save_button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.encryption_save_button.set_title('Save')
        self.encryption_save_button.connect('clicked', self.save_encryption)
        self.encryption_dialog.action_area.add(self.encryption_save_button)
        self.encryption_dialog.show_all()
        self.encryption_dialog.show()
    
    def cb_wep_toggled(self, checkbutton, *args):
        self.entry_key.set_sensitive(checkbutton.get_active())
            
    def startstop_clicked(self, *args):
        """Starts or stops the backend according to current state"""
        if self.backend_started:
            self.stop_backend()
        else:
            self.start_backend()
        self.update_startstop_state()

    def update_startstop_state(self):
        """Update the start/stop button to reflect current state"""
        states = [ gtk.STATE_NORMAL, gtk.STATE_ACTIVE, gtk.STATE_PRELIGHT, gtk.STATE_SELECTED,  gtk.STATE_INSENSITIVE ]
        if self.backend_started:
            self.startstop_button.set_title('Stop')
            #self.startstop_button.set_label('Stop')
            # It seems hildon does not like us messing about with these
#            for state in states:
#                self.startstop_button.modify_bg(state, gtk.gdk.Color(255,0,0))
#                self.startstop_button.modify_base(state, gtk.gdk.Color(255,0,0))
#                self.startstop_eb.modify_bg(state, gtk.gdk.Color(255,0,0))
#                self.startstop_eb.modify_base(state, gtk.gdk.Color(255,0,0))
#                self.startstop_button.modify_text(state, gtk.gdk.Color(255,0,0))
        else:
            self.startstop_button.set_title('Start')
            #self.startstop_button.set_label('Start')
            # It seems hildon does not like us messing about with these
#            for state in states:
#                self.startstop_button.modify_bg(state, gtk.gdk.Color(0,255,0))
#                self.startstop_button.modify_base(state, gtk.gdk.Color(0,255,0))
#                self.startstop_eb.modify_bg(state, gtk.gdk.Color(0,255,0))
#                self.startstop_eb.modify_base(state, gtk.gdk.Color(0,255,0))
#                self.startstop_button.modify_text(state, gtk.gdk.Color(0,255,0))


    def mce_signal_listener(self, *args):
        print "mce_signal_listener got args: " + args
        if (    str(args[0]) == "offline"
            and self.backend_started):
            self.stop_backend()

    def save_connection(self, button, *args):
        """Called via connection_picker_button, saves the current value"""
        self.gc.set_string('/apps/mobilehotspot/connection_name', button.get_value())

    def save_interface(self, button, *args):
        """Called via if_picker_button, saves the current value"""
        self.gc.set_string('/apps/mobilehotspot/interface_name', button.get_value())

    def update_connection_list_listener(self, *args):
        """DBUS signal listerner for IcD2 connection list results"""
        scan_status = int(args[0])
        network_type = str(args[7])
        network_name = str(args[8])
        if scan_status == 4:
            # Scan done, documentation scan restarts after timeout so I suppose we should explicitly cancel it...
            try:
                self.icd2_iface.scan_cancel_req()
                # TODO: Figure out how to disconnect the signal
            except:
                pass
            return
        model = self.connection_selector.get_model(0)
        first_item = model.get_iter_first()
        if first_item != None:
            # In case the network name we got is the first item (ie iserted already), skip it
            if model.get_value(first_item, 0) == network_name:
                return
        self.connection_selector.append_text(network_name)
        if first_item != None:
            # In case the first item is our placeholder, remove it
            if model.get_value(first_item, 0) == 'Please select':
                model.remove(first_item)

    def update_connection_list(self, *args):
        """Updates the selectable connections list"""
        model = self.connection_selector.get_model(0)
        model.clear()
        current_connection_name = self.gc.get_string('/apps/mobilehotspot/connection_name')
        if current_connection_name == None:
            self.connection_selector.append_text('Please select')
        else:
            self.connection_selector.append_text(current_connection_name)
        self.connection_selector.set_active(0,0)
        self.icd2_obj.connect_to_signal('scan_result_sig', self.update_connection_list_listener, 'com.nokia.icd2')
        self.icd2_iface.scan_req(
            dbus.UInt32(1), # ICD_SCAN_REQUEST_ACTIVE_SAVED 0x1
            dbus.Array(
                [
                    dbus.String("GPRS"),
                ]
            )
        )

    def start_backend(self):
        """calls hotspot_backend.py start"""
        import commands
        return_tuple = commands.getstatusoutput('sudo /usr/sbin/mobilehotspot_backend start')
        if return_tuple[0] <> 0:
            print "DEBUG: backend start exit code " + str(return_tuple[0]) + ", output: \n"
            print return_tuple[1]
            note = hildon.hildon_note_new_information(self.mainwindow, 'HotSpot failed to start')
            response = gtk.Dialog.run(note)
            note.destroy()
            return
        self.backend_started = True
        self.update_startstop_state()

    def stop_backend(self):
        """calls hotspot_backend.py stop"""
        import commands
        return_tuple = commands.getstatusoutput('sudo /usr/sbin/mobilehotspot_backend stop')
        if return_tuple[0] <> 0:
            print "DEBUG: backend stop exit code " + str(return_tuple[0]) + ", output: \n"
            print return_tuple[1]
            note = hildon.hildon_note_new_information(self.mainwindow, 'HotSpot failed to stop')
            response = gtk.Dialog.run(note)
            note.destroy()
            return
        self.backend_started = False
        self.update_startstop_state()

    def quit(self, *args):
        """Cleanup routines and possible pre-exit confirmations"""
        if self.backend_started:
            note = hildon.hildon_note_new_confirmation(self.mainwindow, 'HotSpot is active, are you sure you want to quit ?')
            response = note.run()
            note.hide()
            note.destroy()
            if response != gtk.RESPONSE_OK:
                # Not ok to quit, return true to prevent window from being deleted...
                return True
            self.stop_backend()
        gtk.main_quit()

    def mainloop(self):
        """Program entry point; draws windows and enters GTK mainloop"""
        self.mainwindow.show_all()
        # In case we have no connection selected trigger the selector immediately
        if self.gc.get_string('/apps/mobilehotspot/connection_name') == None:
            self.connection_picker_button.emit('clicked')
        gtk.main()

