/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "splashview.h"

/*! 
 *  \brief SplashView constructor.
 */
SplashView::SplashView(void)
{
    qDebug() << "+ " << __PRETTY_FUNCTION__;
    _logo = new TwitterApplicationItem(this);
}

/*! 
 *  \brief SplashView destructor.
 */
SplashView::~SplashView(void)
{
    qDebug() << "~ " << __PRETTY_FUNCTION__;
}

/*! 
 *  \brief Creates the splash screen elements: logo, bird image and the loader.
 */
void SplashView::createUi(void)
{
    QGraphicsPixmapItem *logo = new QGraphicsPixmapItem(_logo);
    logo->setPixmap(QPixmap(":images/resources/logo.png"));
    logo->setPos((800 - _logo->childrenBoundingRect().width())/2,50);

    Loader *loader = new Loader(this);
    loader->startEntryAnimation();
    loader->setZValue(1.0);

    QTimer *timer = new QTimer();
    timer->setSingleShot(true);
    timer->setInterval(1500);
    connect(timer, SIGNAL(timeout()), loader, SLOT(startExitAnimation()));

    connect(loader, SIGNAL(finished()), this, SLOT(onStatic()));

    timer->start();
}

/*! 
 *  \brief This slot is called when the loading time is over and
 * initiates the transition to the login screen.
 */
void SplashView::onStatic(void)
{
    qDebug() << "+ " << __PRETTY_FUNCTION__;
    emit done();
}


