/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LOGINCTRL_H
#define LOGINCTRL_H

#include <QtCore/QObject>

#include <QtGui/QApplication>
#include <QtGui/QGraphicsScene>
#include <QtXml/QXmlStreamWriter>
#include <QtXml/QXmlStreamReader>

#include "loginview.h"
#include "applicationItems/dialog.h"
#include "backend.h"

/*! \class LoginCtrl
 *
 * \brief LoginCtrl class is the controller to LoginView.
 */
class LoginCtrl : public QObject
{
    Q_OBJECT

public:
    LoginCtrl(QGraphicsScene *scene);
    ~LoginCtrl(void);
    void showView(void);
    void loadUsername(void);

private:
    QGraphicsScene *_scene;
    LoginView *_loginView;
    DialogView *_dialog;

private slots:
    void _loginTwitter(void);
    void _exitButtonPressed(void);
    void _connectionError(QString);
    void _saveUsername(void);
    void _exit(void);
    void _abort(void);

signals:
    void accountConnected(void);
    void done(void);
};

#endif // LOGINCTRL_H
