/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the Graphics Dojo project on Qt Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 or 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "mapzoom.h"

#define MAP_HTML "<html><head><script type=\"text/javascript\" " \
    "src=\"http://maps.google.com/maps/api/js?sensor=false\"></script>" \
    "<script  type=\"text/javascript\">" \
    "var map; function init(lat, lng) { "\
    "map = new google.maps.Map(document.getElementById(\"map_canvas\"), " \
    "{ zoom: 14, center: new google.maps.LatLng(lat, lng), " \
    "mapTypeControl: true, mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU}, "\
    "navigationControl: true, navigationControlOptions: {style: google.maps.NavigationControlStyle.SMALL}, "\
    "mapTypeId: google.maps.MapTypeId.ROADMAP  });" \
    "var image = 'http://img401.imageshack.us/img401/2323/pinva.png'; "\
    "var myLatLng = new google.maps.LatLng(lat, lng); "\
    "var marker = new google.maps.Marker({ "\
        "position: myLatLng, "\
        "map: map," \
        "icon: image " \
    "}); " \
    "} "\
    "</script>" \
    "</head><body style=\"margin:0px; padding:0px;\">" \
    "<div id=\"map_canvas\" style=\"width:100%; height:100%\"></div>" \
    "</body></html>"

GMaps::GMaps(QWidget *parent)
    : QWebView(parent)
{
    setAttribute(Qt::WA_OpaquePaintEvent, true);
    QString content = MAP_HTML;
    QWebFrame *frame = page()->mainFrame();

    frame->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOff);
    frame->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOff);
    frame->setHtml(content);
}

void GMaps::setCenter(qreal latitude, qreal longitude)
{
    QString code = "map.set_center(new google.maps.LatLng(%1, %2));";
    QWebFrame *frame = page()->mainFrame();
    frame->evaluateJavaScript(code.arg(latitude).arg(longitude));
}

void GMaps::triggerLoading(qreal latitude, qreal longitude)
{
    QString code = "init(%1, %2)";
    QWebFrame *frame = page()->mainFrame();
    frame->evaluateJavaScript(code.arg(latitude).arg(longitude));
}
