/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef BACKEND_H
#define BACKEND_H

#include <QtCore/QObject>
#include <twitlib/QTwitLib.h>
#include <QtNetwork>

/*! \namespace Timeline Contains different types of timeline to load.
  */
namespace Timeline
{
    enum TimelineType { Users, Friends, Public };
}

/*!
 * \class Backend
 * \brief Handles all operations between the application and the twitlib.
 */
class Backend : public QObject
{
    Q_OBJECT

    public:
        bool isLogin;
        bool cancelNotPressed;
        void DisplayList(QLinkedList<Returnables::StatusElement*> list);
        void DisplayMentionsList(QLinkedList<Returnables::StatusElement*> list);
        void DisplayList(QLinkedList<Returnables::BasicUserInfoElement*> list);
        void DisplayList(QLinkedList<Returnables::ExtUserInfoElement*> list);
        void DisplayList(QLinkedList<Returnables::DirectMessageElement*> list);
        static Backend *getInstance(void);
        void setFriendsPage(int page);
        void setUsersPage(int page);
        int getUsersPage(void);
        int getFriendsPage(void);
        void setMentionsPage(int page);

    public slots:
        void OnResponseReceived(Returnables::Response *);
        bool update(QString status, QString lat, QString lon, QString in_reply_to_status_id);
        bool update(QString status, QString lat, QString lon);
        void setUsernamePassword(QString,QString);
        void getTimeline(Timeline::TimelineType type);
        void verifyCredentials(void);
        QStringList userInfo(void);
        bool addFavorite(unsigned long long int id, bool isFavorite);
        bool removeStatus(unsigned long long int id);
        bool removeFriendship(QString user);
        bool addFriendship(QString user);
        bool sendDirectMessage(QString user, QString text);
        bool updateProfileImage(QString image);
        void getMentions(void);

    public:
        QTwitLib  *m_twitLib;
        QStringList userInformations;

    signals:
        void signedOn(void);
        void connectionError(QString);
        void updateError(QString);
        void updatePosted(void);
        void statusMessage(const QString &name, const QString &text, const QString &imageUrl,
                           const QString &statusId, const QString &createdAt, const QString &source,
                           const bool &favorite, const QString &coordinates, bool isMyTweet, bool m_isUpdate);
        void mentionsStatusMessage(const QString &name, const QString &text, const QString &imageUrl,
                           const QString &statusId, const QString &createdAt, const QString &source,
                           const bool &favorite, const QString &coordinates, bool isMyTweet, bool m_isUpdate);

    private:
        Backend();
        static Backend *_instance;
        SERVER::Option1 *option1;
        SERVER::Option2 *option2;
        SERVER::Option3 *option3;
        bool changeListOrder;
        bool isMyTweet;
        bool m_isUpdate;
};

#endif // BACKEND_H
