/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTWEETINFO_H
#define TWITTERTWEETINFO_H

#include <QtCore/QObject>
#include <QtCore/QRectF>
#include <QtCore/QListIterator>
#include <QtCore/QString>

#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QGraphicsWidget>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>
#include <QtGui/QDesktopServices>
#include <QtGui/QImage>
#include <QtGui/QFontMetrics>

#include <QtNetwork>

#include "twitterapplicationitem.h"
#include "twitterbutton.h"
#include "twittertopbar.h"
#include "tweet.h"
#include "location/mapzoom.h"

/*!
 * \class TwitterTweetInfo
 *
 * \brief TwitterTweetInfo class handles all operations related to timelines
 */
class TwitterTweetInfo : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TwitterTweetInfo(Tweet *tweet, bool atHomeTimeline,QGraphicsWidget *parent=0);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void updateTweetInfo(QString type, bool update);
    QString getTwitPicUrl(void);

signals:
    void retweet(QString);
    void reply(QString, QString);
    void del(QString, int);
    void favorite(QString, bool);
    void unfollow(QString, bool);
    void twitpic(void);

private slots:
    void _favoriteInfo(void);
    void _paintAvatar(void);
    void _reply(void);
    void _retweet(void);
    void _deleteTweet(void);
    void _unfollow(void);
    void _loadMap(void);

private:
    void _createButtons(void);
    void _paintTweet(void);
    void _paintUrlsAndMaps(QStringList urls, QStringList coordinates);
    QString _shortUrl(QString url);
    QStringList _createUrls(QString text);
    bool haveTwitPic(QString m_tweetMessage);

private:
    TwitterButton *m_deleteButton;
    TwitterButton *m_retweetButton;
    TwitterButton *m_replyButton;
    TwitterButton *m_favoriteButton;
    TwitterButton *m_buttonGoToUrl;
    TwitterButton *m_unfollowButton;
    TwitterButton *m_twitPicButton;
    Tweet *_tweet;
    GMaps *m_map;

    QString     m_tweetMessage;
    QString     m_tweetId;
    QString     m_username;
    QString     m_coordinates;
    QString     m_twitPicUrl;
    QStringList m_tweetUrls;
    bool        m_isMyTweet;
    bool        m_favorite;
    bool        m_isFollowing;
    bool        m_atHomeTimeline;
    bool        m_haveTwitPic;
    QImage      m_image;
    QFont       font;
    QGraphicsTextItem *m_tweet;
    QGraphicsLineItem *m_sep1;
    QGraphicsLineItem *m_sep2;
    QGraphicsTextItem *m_message;
};

#endif // TWITTERTWEETINFO_H
