#include "sharedialog.h"
#include "ui_sharedialog.h"

#include <QDebug>


ShareDialog::ShareDialog(MiniDLNAShare *share, Localisation *lc, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ShareDialog)
{
    this->lc = lc;
    this->share = share;
    ui->setupUi(this);
    if(share->Path == "")
    {
        setWindowTitle(lc->CmAddString());
        ui->pushButton_selectfolder->setText(lc->PbSelectFolderString());
    }
    else
    {
        setWindowTitle(lc->CmEditString());
        if(share->Name==".images")
            ui->pushButton_selectfolder->setText(lc->FoPicturesString());
        else if(share->Name==".videos")
            ui->pushButton_selectfolder->setText(lc->FoVideosString());
        else if(share->Name==".sounds")
            ui->pushButton_selectfolder->setText(lc->FoSoundsString());
        else
            ui->pushButton_selectfolder->setText(share->Name);

        if(share->Type == MiniDLNAShare::VIDEO)
            ui->radioButton_video->setChecked(true);
        else if(share->Type == MiniDLNAShare::AUDIO)
            ui->radioButton_audio->setChecked(true);
        else if(share->Type == MiniDLNAShare::IMAGES)
            ui->radioButton_images->setChecked(true);
        else
            ui->radioButton_none->setChecked(true);
    }
    ui->label_folder->setText(lc->LbFolderString());
    ui->label_type->setText(lc->LbTypeString());
    ui->radioButton_none->setText(lc->RbNoneString());
    ui->radioButton_video->setText(lc->RbVideoString());
    ui->radioButton_audio->setText(lc->RbAudioString());
    ui->radioButton_images->setText(lc->RbImagesString());
    ui->pushButton_ok->setText(lc->PbOkString());
    ui->pushButton_abort->setText(lc->PbAbortString());



}

ShareDialog::~ShareDialog()
{
    delete ui;
}

void ShareDialog::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void ShareDialog::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void ShareDialog::on_pushButton_ok_clicked()
{
    if(ui->radioButton_video->isChecked())
        share->Type = MiniDLNAShare::VIDEO;
    else if(ui->radioButton_audio->isChecked())
        share->Type = MiniDLNAShare::AUDIO;
    else if(ui->radioButton_images->isChecked())
        share->Type = MiniDLNAShare::IMAGES;
    else
        share->Type = MiniDLNAShare::NONE;
    this->accept();
}

void ShareDialog::on_pushButton_abort_clicked()
{
    this->close();
}

void ShareDialog::on_pushButton_selectfolder_clicked()
{
    QString dir = QFileDialog::getExistingDirectory(this,"Choose a Directory","/home/user/MyDocs/");
    share->Path = dir;
    QString name = dir.remove(0,dir.lastIndexOf('/')+1);
    //qDebug()<<name;
    if(name==".images")
        ui->pushButton_selectfolder->setText(lc->FoPicturesString());
    else if(name==".videos")
        ui->pushButton_selectfolder->setText(lc->FoVideosString());
    else if(name==".sounds")
        ui->pushButton_selectfolder->setText(lc->FoSoundsString());
    else
        ui->pushButton_selectfolder->setText(name);

    if(name=="")
        ui->pushButton_selectfolder->setText(lc->PbSelectFolderString());
    share->Name = name;
}
