#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gtk/gtk.h>
#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-subscriber/microfeedsubscriber.h>

#include "configuration.h"

int main(int argc, char** argv) {
	MicrofeedConfiguration* configuration;
	MicrofeedSubscriber* subscriber;
	DBusError error;
	DBusConnection* connection;

	gtk_init(&argc, &argv);
	dbus_error_init(&error);
	connection = dbus_bus_get(DBUS_BUS_SESSION, &error);
	dbus_connection_setup_with_g_main(connection, NULL);
	
	configuration = microfeed_configuration_new();
	subscriber = microfeed_subscriber_new("/org/microfeed/Utils/Configuration", configuration, connection);

	show_publishers_dialog(subscriber, NULL);
	
	microfeed_subscriber_free(subscriber);
	
	return 0;
}
