#include <view.h>

View* View::me=NULL;
QApplication* View::app=NULL;
osso_context_t* View::_osso = osso_initialize("com.warda.noscreenblank", "ONE", TRUE, NULL);


View::View(QGraphicsScene* scene_, int validationMode_, Validator* validator_):QGraphicsView(scene_),scene(scene_),validationMode(validationMode_),validator(validator_)
{
	levelDir="/home/opt/mgraph/levels/";
	validatorDir="/home/opt/mgraph/validate/";
	avatarDir="/home/opt/mgraph/avatars/";
	
	solutionReading=0;
	currentMode="mine/";
	readyToSubmit=0;
	username=NULL;
	password=NULL;
	email=NULL;
	ok=NULL;
	infoLayout=NULL;
	reg=NULL;
	anon=NULL;
	graph=NULL;
	draw=1;
	iconTimer=NULL;
	usernameRequested=0;
	iconTrash=NULL;
	won=0;
	levelsNumber=0;
	
	avatarRequested=0;
	usernameRequested=0;

	iconCreator=NULL;
	replyText=NULL;
	
	connectToDbusVibra();
	
	firstSelection=1;

	scale=1.0;
	offsetX=0;
	offsetY=0;
	

	
	iconBack=NULL;
	pageNum=1;	
	maxPageNum=1;

	if (!validationMode)
		init();
	
	
	nodePressed=NULL;

	moveMode=0;

	modeChanged=0;

	bonusAdd=0;

	bonusConsumed=0;

	QTime midnight(0, 0, 0);
	qsrand(midnight.secsTo(QTime::currentTime()));

	levelsListComplete=0;
	
	readyToSave=0;

	networkHandler= new NetworkHandler(this);
	

	user=new User();
	
	if (!validationMode)
	{
		mode=-1;
		if (!user->loggedIn)
			login();
	}
	else
	{
		mode=99;	//validation mode
		firstCheck=1;
		login();
	}
	
		  
	 QObject::connect(&timerTick, SIGNAL(timeout()), this, SLOT(levelTick()));

	
	 
	me=this;


}

void View::start()
{


		if (ok!=NULL)
		{
			delete ok;
			ok=NULL;
		}
		
		
		if (username!=NULL)
		{
			delete username;
			username=NULL;
		}

		if (password!=NULL)
		{
			delete password;
			password=NULL;
		}
		if (infoLayout!=NULL)
		{
			delete infoLayout;
			infoLayout=NULL;
		}
		if (reg!=NULL)
		{
			delete reg;
			reg=NULL;
		}
		if (anon!=NULL)
		{
			delete anon;
			anon=NULL;
		}
		

	if (user->loggedIn)
	{
		
		if (replyText!=NULL)
		{
			delete replyText;
			replyText=NULL;
		}

		
		
		gameButton= new Button(20,20,0,this);

		editorButton= new Button(100,150,1,this);
	
		registerButton= new Button(180,280,2,this);

		scene->addItem(gameButton);
		scene->addItem(editorButton);
		scene->addItem(registerButton);
	}
	else
	{
	
	std::cout<<"asking for login"<<std::endl;

		infoLayout = new QGridLayout;
		
	       	username = new QLineEdit();
		 username->setPlaceholderText(QString("Username"));
		 username->setEchoMode(QLineEdit::PasswordEchoOnEdit);

		 password = new QLineEdit();
		 password->setPlaceholderText(QString("Password"));
		password->setEchoMode(QLineEdit::Password);
		 

		 ok = new QPushButton(QString("OK"),this);
		 anon = new QPushButton(QString("anonymous login"),this);
		 reg = new QPushButton(QString("register"),this);

		  QWidget::connect(ok,SIGNAL(clicked()),this,SLOT(loginOk()));
		  QWidget::connect(reg,SIGNAL(clicked()),this,SLOT(toRegister()));
		  QWidget::connect(anon,SIGNAL(clicked()),this,SLOT(anonLogin()));
		  
		  infoLayout->addWidget(username,20,0);
		  infoLayout->addWidget(password,21,0);
		  infoLayout->addWidget(ok,22,0);
		  infoLayout->addWidget(anon,20,1);
		  infoLayout->addWidget(reg,21,1);
		

		  
		 
		 for (int i=0;i<23;++i)
                	infoLayout->setRowMinimumHeight(i,10);
        
	        setLayout(infoLayout);
		

	}
	
	
}

void View::reset()
{

	if (graph!=NULL)
	{
	//	delete graph;
	//	graph=NULL;
	
		std::cout<<"resetting graph"<<std::endl;
		graph->reset();
	}


	if (validationMode)
	{
		std::cout<<"validation mode on"<<std::endl;
	
		if (validator->step==1)
		{
			std::cout<<"step 1"<<std::endl;
		mode=-2;
		sleep(1);
		std::string url="http://mgg.skomialek.com/verificatorAPI/verificationResult.php?s=";
		url.append(user->sessionID);
		url.append("&r=-1");
		url.append("&id=");
		url.append(levelId);
		std::cout<<"validation result: "<<url<<std::endl;
		won=-1;
		networkHandler->get(url.c_str());
		}
		
		validator->fail();
	}
	
	init();

}

void View::editNodesReset()
{
	for (int i=0;i<editGraph->nodes.size();++i)
	{
		editGraph->nodes[i]->nodeValue=0;
		editGraph->nodes[i]->currentValue=0;
	}

	readyToSave=0;
	editGraph->visitedNodes.clear();
	removeFinger();
	
	if (replyText!=NULL)
	{
		delete replyText;
		replyText=NULL;
	}

}


void View::writeSolution()
{

	if (!readyToSave)
		return;


	std::string text("{");
	text.append("\"id\":");
	text.append("\"");
	text.append(editGraph->id);
	text.append("\"");
	text.append(",\n");
	text.append("\"solution\":");
	text.append("[");

	for (int i=0;i<editGraph->visitedNodes.size();++i)
	{
		text.append(QString::number(editGraph->visitedNodes[i]).toStdString());
		if (i!=editGraph->visitedNodes.size()-1)
			text.append(",");
	}
	
	text.append("]\n");
	text.append("}\n");




	std::string filename(levelDir);
	filename.append("mine/");
	filename.append(editGraph->id);
	filename.append(".sol");
	
	std::ofstream myfile;
	
	myfile.open(filename.c_str());
	
	if (myfile.is_open())
	{
		myfile<<text;
		myfile.close();

	}

	else 
		std::cout<<"error writing"<<std::endl;
	
}


void View::writeLevel()
{
	if (!readyToSave)
		return;

	readyToSubmit=0;
	std::string text("{");
	text.append("\"id\":");
	text.append("\"");
	text.append(editGraph->id);
	text.append("\"");
	text.append(",\n");
	text.append("\"creatorid\":");
	text.append(QString::number(user->userID).toStdString());
	text.append(",\n");
	text.append("\"time\":");
	text.append(QString::number(2*editGraph->nodesSum()).toStdString());
	text.append(",\n");
	text.append("\"nodes\":\n");
	text.append("[\n");

	for (int i=0;i<editGraph->nodes.size();++i)
	{
		text.append("{");
		text.append("\"x\":");
		text.append(QString::number(editGraph->nodes[i]->x).toStdString());
		text.append(",");
		
		text.append("\"y\":");
		text.append(QString::number(editGraph->nodes[i]->y).toStdString());
		text.append(",");
		
		text.append("\"value\":");
		text.append(QString::number(editGraph->nodes[i]->nodeValue).toStdString());

		
		text.append("}");

		if (i!=(editGraph->nodes.size()-1))
			text.append(",\n");

	}

	
		text.append("],\n");
		
		
		
		
		text.append("\"edges\":\n");
		text.append("[\n");




		for (int i=0;i<editGraph->edges.size();++i)
		{
			text.append("{");
			
			text.append("\"nodeA\":");
			text.append(QString::number(getNodeIndex(editGraph->edges[i]->nodeA)).toStdString());
			text.append(",");

			text.append("\"nodeB\":");
			text.append(QString::number(getNodeIndex(editGraph->edges[i]->nodeB)).toStdString());
			text.append(",");


			text.append("\"bonuses\":");
			text.append(QString::number(editGraph->edges[i]->bonuses.size()).toStdString());
			
			
			
			text.append("}");

			if (i!=(editGraph->edges.size()-1))
				text.append(",\n");
			

		}



		
		text.append("\n]\n");
		text.append("\n}");
		


	std::string filename(levelDir);
	filename.append("mine/");
	filename.append(editGraph->id);
	filename.append(".lev");
	
	std::ofstream myfile;
	
	myfile.open(filename.c_str());
	
	if (myfile.is_open())
	{
		myfile<<text;
		myfile.close();
		readyToSubmit=1;

		if (replyText!=NULL)
		{
			delete replyText;
			replyText=NULL;
		}
		replyText=scene->addText("saving successful");
		replyText->setPos(520,420);

	}

	else 
		std::cout<<"error writing"<<std::endl;


}



int View::handleResult(void* ctx, int type, const JSON_value* value)
{


	if (me==NULL)
		return 0;
	
switch(type)
    {
    case JSON_T_ARRAY_BEGIN:
	    me->s_IsKey = 0;
        break;
    case JSON_T_ARRAY_END:
        assert(!me->s_IsKey);
        break;  
   case JSON_T_OBJECT_BEGIN:
       me->s_IsKey = 0;
       break;
    case JSON_T_OBJECT_END:
        assert(!me->s_IsKey);
        break;  
    case JSON_T_INTEGER:
	me->s_IsKey = 0;
	if (!me->solutionReading)
		me->setInt(value->vu.integer_value);
	else
		me->validator->setInt(value->vu.integer_value);
        break;
    case JSON_T_FLOAT:
        me->s_IsKey = 0;
        break;
    case JSON_T_NULL:
        me->s_IsKey = 0;
        break;
    case JSON_T_TRUE:
        me->s_IsKey = 0;
        break;
    case JSON_T_FALSE:
        me->s_IsKey = 0;
        break;
    case JSON_T_KEY:
        me->s_IsKey = 1;
	if (me->validationMode)
		me->validator->key=value->vu.str.value;
        me->key=value->vu.str.value;
        break;
    case JSON_T_STRING:
        me->s_IsKey = 0;
	if (!me->solutionReading)
		me->setString(value->vu.str.value);
	else
		me->validator->setString(value->vu.str.value);
        break;
    default:
        assert(0);
        break;
    }

return 1;

}



void View::setInt(int value_)
{
	
	if (graph==NULL)
	       return;	
	
	
	 if (key.compare("creatorid")==0)
	 {
	  		 graph->creatorID=value_;
			 if (!validationMode)
			 {
				 int found=0;

				for (int i=0; i<someones.size(); ++i)
				{
					if (graph->creatorID==someones[i]->id)
					{
						graph->creatorName=someones[i]->name;
						found = 1;
						std::cout<<"user found"<<someones[i]->name<<std::endl;
						
						int foundA=0;
						for (int i=0;i<pixIDs.size();++i)
						{
							if (pixIDs[i]==graph->creatorID)
							{
								system("touch /home/opt/mgraph/avatars/*");
								std::string filename=avatarDir;
								filename.append(QString::number(graph->creatorID).toStdString());
								avatarRequested=0;
								std::cout<<"*****avatar found "<<filename.c_str()<<std::endl; 
					
						
								if (creatorPix.load(filename.c_str()))
									std::cout<<"success "<<creatorPix.width()<<std::endl;

								scene->update();
				//	return;
								foundA=1;
							}
				
						}
			
					if (!foundA)
						getUserAvatar(graph->creatorID);
						
					}

				}
				
				if (!found)
				 	getUserName(graph->creatorID);
			 }
	 }
			 
	 if (key.compare("time")==0)
	 {
	                 graph->time=value_;
			 graph->currentTime=value_;
	 }	
	 if (key.compare("x")==0)
	                 creatingNodeX=value_;
	 if (key.compare("y")==0)
	                 creatingNodeY=value_;
	 if (key.compare("value")==0)
	 {
	                 creatingNodeValue=value_;
			 graph->addNode(new Node((qreal)creatingNodeX*scale+offsetX,(qreal)creatingNodeY*scale+offsetY,creatingNodeValue));
	 }
			 
	 if (key.compare("nodeA")==0)
	                 creatingEdgeNodeA=value_;
	 if (key.compare("nodeB")==0)
	                 creatingEdgeNodeB=value_;
	 if (key.compare("bonuses")==0)
	 {
	                 creatingEdgeBonuses=value_;
			 graph->addEdge(new Edge(graph->nodes[creatingEdgeNodeA],graph->nodes[creatingEdgeNodeB],creatingEdgeBonuses));
	 }


	 
}

void View::setString(std::string value_)
{
	 if (key.compare("id")==0)
	                 levelId=value_;

}



void View::loadLevel(std::string name_)
{
	std::string toOpen;
	
	
	if (!validationMode)
	{
		toOpen=levelDir;
		toOpen.append(currentMode);
	}
	else
		toOpen=validatorDir;
	
	toOpen.append(name_);
	
	
	input = fopen(toOpen.c_str(),"r");
	if (input)
	{
		 init_JSON_config(&config);
	}
	else
		return;
	
	 config.depth = 20;
 	 config.callback = &handleResult;
	 config.allow_comments = 1;
	 config.handle_floats_manually = 0;
	 jc = new_JSON_parser(&config);

	 count=0;
	 s_IsKey=0;
		
 

	 for (; input ; ++count)
 	 {
		 int next_char = fgetc(input);
		 if (next_char <= 0)
		 {
			 break;
		 }
		 
		 if (!JSON_parser_char(jc, next_char))
		 {
			 delete_JSON_parser(jc);
			 return;
		 }
	 }
	 

	 if (!JSON_parser_done(jc))
	 {
		 delete_JSON_parser(jc);
		 return;

	 }

 	 fclose(input);
	 
}


void View::readLevels(const char* subDir)
{
	levels.clear();
	
	DIR* dir_p;

	struct dirent *dir_entry_p;

	if (validationMode)
	{
	
		std::cout<<"readLevels validation"<<std::endl;
		dir_p = opendir(validatorDir.c_str());                                                                                              
		while(NULL != (dir_entry_p = readdir(dir_p)))
		{


			if (dir_entry_p->d_name[strlen(dir_entry_p->d_name)-3]=='l' && dir_entry_p->d_name[strlen(dir_entry_p->d_name)-2] == 'e' && dir_entry_p->d_name[strlen(dir_entry_p->d_name)-1] == 'v' )
			{	
				validator->levelsToValidate.push_back(dir_entry_p->d_name);
			}
			else if (dir_entry_p->d_name[strlen(dir_entry_p->d_name)-3]=='s' && dir_entry_p->d_name[strlen(dir_entry_p->d_name)-2] == 'o' && dir_entry_p->d_name[strlen(dir_entry_p->d_name)-1] == 'l' )
			{	
				validator->solutionsToValidate.push_back(dir_entry_p->d_name);
			}
		
		}		


			closedir(dir_p);
		return;
	}


	std::string tmp=levelDir;
	tmp.append(currentMode);
	
	dir_p = opendir(tmp.c_str());                                                                                              
	while(NULL != (dir_entry_p = readdir(dir_p)))
	{


		if (dir_entry_p->d_name[strlen(dir_entry_p->d_name)-3]=='l' && dir_entry_p->d_name[strlen(dir_entry_p->d_name)-2] == 'e' && dir_entry_p->d_name[strlen(dir_entry_p->d_name)-1] == 'v' )
		{	
			levels.push_back(dir_entry_p->d_name);
		}
		
	}		


	closedir(dir_p);

	
}

void View::levelChosen(const QModelIndex & index )
{

	if (levelsNumber!=0)
		return;
	
//	previewGraph=new Graph();
	
	
	
	
	if (graphChosen==index.row() && !firstSelection)
		return;

	firstSelection=0;

	
	if (graph!=NULL)
	{
		delete graph;
		graph=NULL;
	}
	
	graph=new Graph();	
	
	
	graphChosen=index.row();
		
	std::string tmp=levels[index.row()];
	tmp.erase(levels[index.row()].length()-4);

	currentGraphId=tmp;

	std::cout<<"*****"<<currentGraphId<<std::endl;
	
	scale=0.5;
	offsetX=400;
	offsetY=120;
	  
	loadLevel(levels[index.row()]);
	
	
	
	if (iconCreator!=NULL)
	{
		delete iconCreator;
		iconCreator=NULL;
	}

	
	iconCreator=new Icon(700,455,6);
	scene->addItem(iconCreator);

	
	
		

	
		for (int i=0;i<graph->nodes.size();++i)
			scene->addItem(graph->nodes[i]);
	
		for (int i=0;i<graph->edges.size();++i)
		{
			scene->addItem(graph->edges[i]);
			for (int k=0;k<graph->edges[i]->bonuses.size();++k)
			{
				scene->addItem(graph->edges[i]->bonuses[k]);
			}
		}

	
	
}



void View::registerOk()
{
	std::string usernameS = std::string(username->text().toStdString());
	std::string passwordS = std::string(password->text().toStdString());
	std::string emailS = std::string(email->text().toStdString());

	std::cout<<"requesting username "<<usernameS<<" and password "<<passwordS<<std::endl;

	std::string url="http://mgg.skomialek.com/deviceAPI/newUser.php?u=";
	url.append(usernameS);
	url.append("&p=");
	url.append(passwordS);
	url.append("&e=");
	url.append(emailS);
		
	avatarRequested=0;
	usernameRequested=0;
	
	if (user->userPhoto->isSet)
	{
		networkHandler->post(url.c_str(),user->avatarFileName.c_str());
		std::cout<<"posting"<<std::endl;
	}
	else
	{
		networkHandler->get(url.c_str());
		std::cout<<"requested"<<std::endl;
	}
	
}



void View::init()
{

	
	if (iconBack==NULL && !validationMode)
	{
		iconBack=new Icon(720,0,0); //back
		scene->addItem(iconBack);
	}
	

	if (mode==99) //validation mode
	{

		/*
		
		if (graph!=NULL)
		{
			delete graph;
			graph=NULL;

		}
*/

		if (firstCheck)
		{
			readLevels("mine");
			graph=new Graph();
			loadLevel(validator->levelsToValidate[0]);
			firstCheck=0;
			solutionReading=1;
			std::string temp=levelId;
			loadLevel(temp.append(".sol"));
			solutionReading=0;

		
		for (int i=0;i<validator->solution.size();++i)
		{
		}

		
		for (int i=0;i<graph->nodes.size();++i)
			scene->addItem(graph->nodes[i]);
	
		for (int i=0;i<graph->edges.size();++i)
		{
			scene->addItem(graph->edges[i]);
			for (int k=0;k<graph->edges[i]->bonuses.size();++k)
			{
				scene->addItem(graph->edges[i]->bonuses[k]);
			}
		}
		}
		
		
		
		removeFinger();

		finger=new Finger(graph->nodes[validator->solution[0]]->centerX,graph->nodes[validator->solution[0]]->centerY,this);
		finger->draw=1;
		scene->addItem(finger);

		return;
	}

	

	if (mode==6)
	{


		if (replyText!=NULL)
		{
			delete replyText;
			replyText=NULL;
		}
		
		if (registrationFailed==1)
		{
		replyText=scene->addText(serverReply.c_str());
		replyText->setPos(150,100);
				return;
		}
		
		else if (!registrationFailed)
		{
				replyText=scene->addText("Registration successful");
					replyText->setPos(150,100);
				return;
		}
		

		
		infoLayout = new QGridLayout;

		 username = new QLineEdit();
		 username->setPlaceholderText(QString("Username"));
		 username->setEchoMode(QLineEdit::PasswordEchoOnEdit);

		 password = new QLineEdit();
		 password->setPlaceholderText(QString("Password"));
		password->setEchoMode(QLineEdit::Password);
		 
		email = new QLineEdit();
		 email->setPlaceholderText(QString("Email"));
		email->setEchoMode(QLineEdit::PasswordEchoOnEdit);
		 
		 ok = new QPushButton(QString("OK"),this);
		


		 
		  infoLayout->addWidget(email,19,0);
		  infoLayout->addWidget(username,20,0);
		  infoLayout->addWidget(password,21,0);
		  infoLayout->addWidget(ok,22,0);
			
		  
		  QWidget::connect(ok,SIGNAL(clicked()),this,SLOT(registerOk()));


		 for (int i=0;i<23;++i)
                	infoLayout->setRowMinimumHeight(i,10);
        
	        setLayout(infoLayout);

		user->userPhoto->x=20;
		user->userPhoto->y=20;
		scene->addItem(user->userPhoto);
       	





		

	}
	
	else if (mode==4)	//choosing graph
	{


		
		readLevels("mine");

		if (graph!=NULL)
		{
			delete graph;
			graph=NULL;
		}
		

		listWidget = new QListWidget();
			//	listWidget->setSortingEnabled(true);
//		listWidget->grabMouse();

		firstSelection=1;
		
	QAbstractKineticScroller *scroller;
	scroller = listWidget->property("kineticScroller").value<QAbstractKineticScroller *>();
	scroller->setEnabled(true);
		

		listWidget->resize(420,410);
			
		connect(listWidget,SIGNAL(pressed(QModelIndex)),this,SLOT(levelChosen(QModelIndex)));
			
		for (int i=0;i<levels.size();++i)
		{
			std::string tmp=levels[i];
			tmp.erase(levels[i].length()-4);
			new QListWidgetItem(tmp.c_str(), listWidget);
		} 
		
		
		newest = new QPushButton(QString("newest"));
		QWidget::connect(newest,SIGNAL(pressed()),this,SLOT(newestClicked()));
		newest->move(105,410);
		 
		 
		mine = new QPushButton(QString("mine"));
		QWidget::connect(mine,SIGNAL(clicked()),this,SLOT(mineClicked()));
		mine->move(315,410);
		
		left = new QPushButton(QString("<<"));
		QWidget::connect(left,SIGNAL(clicked()),this,SLOT(leftClicked()));
		left->move(0,410);
		
		right = new QPushButton(QString(">>"));
		QWidget::connect(right,SIGNAL(clicked()),this,SLOT(rightClicked()));
		right->move(210,410);
		
		//listWidget->show();
		scene->addWidget(listWidget);
		scene->addWidget(newest);
		scene->addWidget(mine);
		scene->addWidget(left);
		scene->addWidget(right);

	}
	
	else if (mode==2) //editor
	{
		editGraph=new EditGraph();

		networkHandler->get("");
		

		std::string url="http://mgg.skomialek.com/deviceAPI/submitLevel.php?s=";
		url.append(user->sessionID);

		networkHandler->get(url.c_str());
	

		requestingLevelID=1;
		
		
		iconMove=new Icon(20,410,1);
		scene->addItem(iconMove);

		iconTrash=new Icon(0,380,2);
		scene->addItem(iconTrash);

		iconRecord=new Icon(90,410,3);
		scene->addItem(iconRecord);
		
		iconBonus=new Icon(160,410,4);
		scene->addItem(iconBonus);

		iconSave=new Icon(230,410,5);
		scene->addItem(iconSave);

		iconSubmit=new Icon(300,410,7);
		scene->addItem(iconSubmit);

	}

	
	else if (mode==1) //solving
	{


	
		if (graph!=NULL)
		{

		}
		
		if (graph==NULL)
		{
				
			graph=new Graph();
		
		
			loadLevel(levels[graphChosen]);
		
			
			for (int i=0;i<graph->nodes.size();++i)
				scene->addItem(graph->nodes[i]);
	
			for (int i=0;i<graph->edges.size();++i)
			{
				scene->addItem(graph->edges[i]);
				for (int k=0;k<graph->edges[i]->bonuses.size();++k)
				{
					scene->addItem(graph->edges[i]->bonuses[k]);
				}
			}
		
		if (iconTrash!=NULL)
		{
			delete iconTrash;
			iconTrash=NULL;
		}
		
		
		iconTrash=new Icon(0,380,2);
		scene->addItem(iconTrash);
	
		if (iconCreator!=NULL)
		{
			delete iconCreator;
			iconCreator=NULL;
		}
	
		
		iconCreator=new Icon(700,455,6);
		scene->addItem(iconCreator);

		
		if (iconTimer!=NULL)
		{
			delete iconTimer;
			iconTimer=NULL;
		}
	
		
		iconTimer=new Icon(10,455,8);
		scene->addItem(iconTimer);

		
		toReset=0;
		
		
		

		timerTick.start(1000);

			
		}



		
	//Bonus::graph=graph;
	
	

	}
}


void View::connectToDbusVibra()
{

        dbus_error_init(&errVib);
        connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
        if (dbus_error_is_set(&errVib))
        {
                dbus_error_free(&errVib);
        }


        if (NULL == connVib)
        {
                return;
        }

        retVib = dbus_bus_request_name(connVib, "sheep.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING 
, &errVib);

        if (dbus_error_is_set(&errVib))
        {
                dbus_error_free(&errVib);
        }

        if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib)
        {
                return;
        }
        connectedVib=1;
}


void View::vibrate(int type)
{

        if (type==0) //change this to enum
        {
                paramVib = "PatternTouchscreen";
        }

        else if (type==1)
        {
                paramVib = "PatternPowerKeyPress";
        }

        else if (type==2)
        {
                paramVib= "PatternChatAndEmail";
        }

        if (connectedVib==0)
        {
                connectToDbusVibra();
                if (connectedVib==0)
                        return;
        }

        msgVib = dbus_message_new_method_call("com.nokia.mce",
                        "/com/nokia/mce/request",
                        "com.nokia.mce.request",
                        "req_vibrator_pattern_activate");



        if (NULL == msgVib)
        {
                return;
        }

        dbus_message_iter_init_append(msgVib, &argsVib);

        if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib))
        {
                return;
        }

        if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1))
        {
                return;
        }

        if (NULL == pendingVib)
        {
                return;
        }

        dbus_connection_flush(connVib);
        dbus_message_unref(msgVib);

}



int View::getNodeIndex(Node* node_)
{


	for (int i=0;i<editGraph->nodes.size();++i)
	{
		if (editGraph->nodes[i]==node_)
			return i;
	}	

	return -1;
}




void View::mousePressEvent(QMouseEvent* event)
{
	

	

		if (iconBack->boundingRect().contains(event->globalX()-iconBack->x,event->globalY()-iconBack->y))
		{
				readyToSave=0;
				readyToSubmit=0;


				if (mode==-1)
					app->quit();

				else if (mode==1 || mode == 5) //win
				{
					mode=4;
					removeFinger();
					if (iconTrash!=NULL)
					{
						delete iconTrash;
						iconTrash=NULL;
					}
					if (iconCreator!=NULL)
					{
						delete iconCreator;
						iconCreator=NULL;
					}
					if (iconTimer!=NULL)
					{
						delete iconTimer;
						iconTimer=NULL;
					}
					if (replyText!=NULL)
					{
						delete replyText;
						replyText=NULL;
					}
					timerTick.stop();
					init();
					

				}

				else if (mode==4)
				{
					mode=-1;
					if (iconCreator!=NULL)
					{
						delete iconCreator;
						iconCreator=NULL;
					}
					if (graph!=NULL)
					{
						delete graph;
						graph=NULL;
					}
					delete listWidget;
					delete newest;
					delete mine;
					delete left;
					delete right;
					offsetX=0;
					offsetY=0;
					scale=1;
					start();
					init();
				}
				else if (mode==3 || mode==2)
				{
					if (editGraph!=NULL)
					{
						delete editGraph;
						editGraph=NULL;
					}
					mode=-1;
					delete iconMove;
					if (iconTrash!=NULL)
					{
						delete iconTrash;
						iconTrash=NULL;
					}
					delete iconRecord;
					delete iconBonus;
					delete iconSave;
					delete iconSubmit;
					moveMode=0;
					start();
					init();
					
				}
			
				else if (mode==6) //registration
				{

					if (username!=NULL)
					{
					delete username;
					username=NULL;
					}
					if (password!=NULL)
					{
					delete password;
					password=NULL;
					}
					if (email!=NULL)
					{
					delete email;
					email=NULL;
					}
					if (ok!=NULL)
					{
						delete ok;
						ok=NULL;
					}
					if (infoLayout!=NULL)
					{
					delete infoLayout;
					infoLayout=NULL;
					}
					scene->removeItem(user->userPhoto);
					if (replyText!=NULL)
					{
						delete replyText;
						replyText=NULL;
					}	
					
					user->loggedIn=0;
					mode=-1;
					login();
					init();

				}
				
				return;

		}
	

	if (mode==6)
	{
		if (user->userPhoto->boundingRect().contains(event->globalX()-user->userPhoto->x,event->globalY()-user->userPhoto->y))
		{

			user->avatarFileName = QFileDialog::getOpenFileName(NULL,tr("Open Image"), "/home/user/MyDocs/.images/", tr("Image Files (*.png *.jpg)")).toStdString();

			
			if (strcmp(user->avatarFileName.c_str(),"")==0)
			{
				user->userPhoto->isSet=0;
				user->userPhoto->update();

			}
			else
			{
				user->userPhoto->photoPix.load(user->avatarFileName.c_str());
				user->userPhoto->isSet=1;
				user->userPhoto->update();
		
			}

		}
		
	}
		
	
	if (mode==4)
	{
		if (event->globalX()<400 || event->globalY()>400) 
		{
		
			QGraphicsView::mousePressEvent(event);
		//	QWidget::mousePressEvent(event);
			event->ignore();
			return;
		}


		else if (event->globalX()>400 && levelsNumber==0)
		{
			if (listWidget!=NULL)
				delete listWidget;
			delete newest;
			delete mine;
			delete left;
			delete right;
			scale=1;
			offsetX=0;
			offsetY=0;
			mode=1;
			if (graph!=NULL)
			{
				delete graph;
				graph=NULL;
			}
			toReset=0;
			init();
			return;
		}
		else if (levelsNumber!=0)
		{
			std::cout<<"problem "<<levelsNumber<<std::endl;
		}


	}

	if (mode==-1 && user->loggedIn)//mode choosing
	{
		if (gameButton->boundingRect().contains(event->globalX()-gameButton->x,event->globalY()-gameButton->y))
		{
			levelsNumber=0;
			mode=4;
		}
		else if (editorButton->boundingRect().contains(event->globalX()-editorButton->x,event->globalY()-editorButton->y))
		{
			mode=2;
		}
		else if (registerButton->boundingRect().contains(event->globalX()-registerButton->x,event->globalY()-registerButton->y))
		{
			registrationFailed=-1;
			mode=6;
		}

		else
			return;


		
		delete gameButton;
		delete editorButton;
		delete registerButton;
			
		init();

		return;
	}
	
		

	if (mode==2 || mode==3)
	{
		if (iconRecord->boundingRect().contains(event->globalX()-iconRecord->x,event->globalY()-iconRecord->y))
		{

			iconRecord->update();
			
			if (mode==2)
			{
				mode=3; //recording solution
				moveMode=0;
				bonusAdd=0;
			}
			else if (mode==3)
				mode=2;
			return;

		}
		
		if (iconSave->boundingRect().contains(event->globalX()-iconSave->x,event->globalY()-iconSave->y))
		{

			writeSolution();
			writeLevel();
			return;

		}
		
		if (iconSubmit->boundingRect().contains(event->globalX()-iconSubmit->x,event->globalY()-iconSubmit->y))
		{
			submissionFinishedCounter=0;

			if (submitLevel()) //nothing, moved to replyFinished
			{
				//if (submitSolution())
				{

				}
			}
			return;

		}
		
		if (iconBonus->boundingRect().contains(event->globalX()-iconBonus->x,event->globalY()-iconBonus->y))
		{

			bonusAdd=!bonusAdd;
			iconBonus->update();
			mode=2;
			moveMode=0;
			
			return;

		}
	}


		
	if (mode==2 || mode==3)
	{

		nodePressed=NULL;
		
		if (iconMove->boundingRect().contains(event->globalX()-iconMove->x,event->globalY()-iconMove->y))
		{
			mode=2;
			iconMove->update();
			moveMode=!moveMode;
			bonusAdd=0;
			modeChanged=1;

			if (nodeA!=NULL)
			{
				nodeA->touched=0;
				nodeA->update();
				nodeA=NULL;
			}
			for (int i=0; i<editGraph->nodes.size();++i)
			{

				editGraph->nodes[i]->update();
			}
		
			return;
		}
		
		if (mode==3)
			editNodesReset();

	}
		
		
	
	
	if (mode==1 || mode==3 || bonusAdd)//game and recording
	{	
		finger=new Finger(event->globalX(),event->globalY(),this);
		finger->draw=draw;
		scene->addItem(finger);
		return;
	}

	
		
		

	if (mode==2)
	{	
		for (int i=0; i<editGraph->nodes.size();++i)
		{
			
			if (editGraph->nodes[i]->boundingRect().contains(event->globalX()-editGraph->nodes[i]->x,event->globalY()-editGraph->nodes[i]->y))
			{
				nodePressed=editGraph->nodes[i];
				
				nodePressed->update();

				
				if (moveMode)
					return;
				
				if (nodeA==NULL)
				{
					nodeA=nodePressed;
					nodeA->touched=1;
				}
				else if (nodePressed!=nodeA)
				{
					nodeB=nodePressed;
					editGraph->addEdge(new Edge(nodeA,nodeB));
					scene->addItem(editGraph->edges.back());
					nodeA->touched=0;
					nodeA=NULL;
					nodeB=NULL;
				}
				else if (nodePressed==nodeA)
				{
					nodeA->touched=0;
					nodeA=NULL;
					nodeB=NULL;
				}
			}
		}
		
		if (nodePressed==NULL && nodeA==NULL && !moveMode && !modeChanged && event->globalY()<360)
		{


	/*		
			for (int k=0;k<editGraph->nodes.size();++k)
			{
				qreal d = sqrt(pow(event->globalX()-editGraph->nodes[k]->centerX,2)+pow(event->globalY()-editGraph->nodes[k]->centerY,2));
				if (d<120)
					return;
			}
	*/
			
			
			
			editGraph->addNode(new Node((int)(event->globalX()/20)*20-15,(int)(event->globalY()/20)*20-15,0));
			scene->addItem(editGraph->nodes.back());
		}
		
		 

		if (nodePressed==NULL)
		{
			lastX=event->globalX();
			lastY=event->globalY();
		}



		
	}
	

	
}


void View::mouseMoveEvent(QMouseEvent* event)
{

	if (mode==4)
	{

		if (event->globalX()<400 || event->globalY()>400)
		{
		
			QGraphicsView::mouseMoveEvent(event);
			event->ignore();
			return;
		}
		
	}
	
	if (mode==1 || mode==3)
	{
		if (finger!=NULL)
		{
			
			if ((finger->xx.size()>0 && sqrt(pow(finger->xx.back()-event->globalX(),2)+pow(finger->yy.back()-event->globalY(),2))> 10) || finger->xx.size()==0)
			{
				finger->xx.push_back(finger->x);
				finger->yy.push_back(finger->y);
			}
			if (finger->xx.size()>3)
			{
				finger->xx.erase(finger->xx.begin());
				finger->yy.erase(finger->yy.begin());
			}
			
			finger->x=event->globalX();
			finger->y=event->globalY();
		}

	}

	else if (mode == 2)
	{
		
		if (nodePressed!=NULL && moveMode)
		{
			/*
			for (int k=0;k<editGraph->nodes.size();++k)
			{

				if (editGraph->nodes[k]!=nodePressed)
				{
					qreal d = sqrt(pow(event->globalX()+30-editGraph->nodes[k]->centerX,2)+pow(event->globalY()+30-editGraph->nodes[k]->centerY,2));
					if (d<180)
						return;
				}
			}
*/

			nodePressed->x=int((event->globalX()/20)*20);
			nodePressed->y=int((event->globalY()/20)*20);

			if (iconTrash->boundingRect().contains(nodePressed->x-iconTrash->x,nodePressed->y-iconTrash->y))
			{
				editGraph->deleteNode(nodePressed);
				nodePressed=NULL;
				readyToSave=0;

			}

				
		}
	}
}

void View::removeFinger()
{
	if (finger==NULL)
		return;

	delete finger;
	finger=NULL;
}


void View::mouseReleaseEvent(QMouseEvent* event)
{
	if (mode==4 && (event->globalX()<400 || event->globalY()>400))
	{

		QGraphicsView::mouseReleaseEvent(event);
		event->ignore();
		return;
		
	}

	
	if (bonusAdd || mode==3 || mode==5)
	{
		removeFinger();
		bonusConsumed=0;
	}
	
	else if (mode==1)
	{
		removeFinger();
		if (toReset)
			reset();
	}

	else if (mode==2)
	{
		nodePressed=NULL;
		modeChanged=0;

	}
}




void View::win()
{

	if (!validationMode)
	{
	std::cout<<"WIN"<<std::endl;
	vibrate(2);
	mode=5;
	
	timerTick.stop();
	
	if (replyText!=NULL)
	{
		delete replyText;
		replyText=NULL;
	}

		replyText=scene->addText("You win!");
		replyText->setPos(350,420);
	}
	
	else if (validationMode)
	{
		mode=-2;
		sleep(1);
		std::string url="http://mgg.skomialek.com/verificatorAPI/verificationResult.php?s=";
		url.append(user->sessionID);
		url.append("&r=1");
		url.append("&id=");
		url.append(levelId);
		std::cout<<"validation result: "<<url<<std::endl;
		networkHandler->get(url.c_str());
		validator->win();
		won=1;

	}

}


void View::replyFinished(const char* data,int option)
{
	if (data!=NULL)
		std::cout<<"replyFinished"<<std::endl;
	else
		std::cout<<"OOOOPS"<<std::endl;


	if (validationMode && won)
	{	
		app->quit();

	}
	
	if (validationMode && won==-1)
	{	
		app->quit();

	}
	
	if (usernameRequested && !option)
	{
		std::string tempString(data);
		
		if (graph==NULL)
			return;
		
		QString dataStr(tempString.c_str());
		
		QStringList list1 = dataStr.split("@");

		if (list1[0].compare(QString("0"))==0)
		{
			graph->creatorName=list1[1].toStdString();

			someones.push_back(new Someone(graph->creatorID,graph->creatorName));

			usernameRequested=0;
			
			int found=0;
			for (int i=0;i<pixIDs.size();++i)
			{
				if (pixIDs[i]==graph->creatorID)
				{
					system("touch /home/opt/mgraph/avatars/*");
					std::string filename=avatarDir;
					filename.append(QString::number(graph->creatorID).toStdString());
					avatarRequested=0;
					std::cout<<"*****avatar found "<<filename.c_str()<<std::endl; 
					
						
					if (creatorPix.load(filename.c_str()))
						std::cout<<"success "<<creatorPix.width()<<std::endl;

					scene->update();
				//	return;
					found=1;
				}
				
			}
			
			if (!found)
				getUserAvatar(graph->creatorID);
			
			
		}
	
		
		return;
	}


	if (avatarRequested && !option)
	{
		std::string tempString(data);
		
		QString dataStr(tempString.c_str());
		
		QStringList list1 = dataStr.split("@");

		if (list1[0].compare(QString("0"))==0)
		{
			std::cout<<"downloading avatar "<<list1[1].toStdString()<<std::endl;
			std::string filename=avatarDir;
			filename.append(QString::number(graph->creatorID).toStdString());
			
			networkHandler->getFile(list1[1].toStdString().c_str(),filename.c_str());
		}
		
	
		
		return;
	}
	

	std::cout<<"replyFinished 2"<<std::endl;
	
	if ((mode==-1 || mode==99) && !user->loggedIn)	//logging
	{
	

		std::string tempString(data);
		
		QString dataStr(tempString.c_str());
		std::cout<<dataStr.toStdString()<<std::endl;
		
		QStringList list1 = dataStr.split("@");

		if (list1[0].compare(QString("0"))==0)
		{
			
			std::cout<<"logging successful "<<std::endl;
			user->loggedIn=1;
			user->sessionID=list1[1].toStdString();
			
			if (validationMode)
				return;
			
			iconBack->update();
			if (user->username.compare("Anonymous")!=0)
			{
				if (username!=NULL && password!=NULL)
				{
					user->username = std::string(username->text().toStdString());
					user->password = std::string(password->text().toStdString());
				}
				user->userID=list1[2].toInt();
			
				std::string text(user->username);
				text.append("@");
				text.append(user->password);
				text.append("@");
				text.append(QString::number(user->userID).toStdString());

			
				std::string filename("/home/opt/mgraph/login");
				std::ofstream myfile;
	
				myfile.open(filename.c_str());
	
				if (myfile.is_open())
				{
					myfile<<text;
					myfile.close();

				}

				else 
					std::cout<<"error writing"<<std::endl;
			}

		}
		else
		{
			std::cout<<"logging failed"<<std::endl;
			user->loggedIn=0;
		
			if (replyText!=NULL)
			{
				delete replyText;
				replyText=NULL;
			}

			replyText=scene->addText(list1[1]);
			replyText->setPos(150,100);


		}
		start();
		
	}

	else if (mode==6)	//registration
	{
		

		std::cout<<"replyFinished 3"<<std::endl;
	
		std::cout<<data<<std::endl;
		std::string tempString(data);

		std::cout<<"replyFInished 3.1"<<std::endl;
		std::cout<<tempString<<std::endl;
		
		QString dataStr(tempString.c_str());
		
		QStringList list1 = dataStr.split("@");

		
		if (list1[0].compare(QString("0"))==0)
		{


			registrationFailed=0;
			if (ok!=NULL)
			{
				delete ok;
				ok=NULL;
			}
			user->userID=list1[1].toInt();
	
	
			user->username = std::string(username->text().toStdString());
			user->password = std::string(password->text().toStdString());
			user->email = std::string(email->text().toStdString());
			
			
			std::string text(user->username);
			text.append("@");
			text.append(user->password);
			text.append("@");
			text.append(QString::number(user->userID).toStdString());

			std::cout<<"replyFinished 4"<<std::endl;

			std::string filename("/home/opt/mgraph/login");
			std::ofstream myfile;
	
			myfile.open(filename.c_str());
	
			std::cout<<"replyFinished 5"<<std::endl;
			
			if (myfile.is_open())
			{
				myfile<<text;
				myfile.close();

			}

			else 
				std::cout<<"error writing"<<std::endl;
				init();
		}
		else
		{
			serverReply=list1[1].toStdString();
			registrationFailed=1;
			init();
	
		}


	}
	else if (mode==2 || mode==3)//editor submission
	{
		std::string tempString(data);

		
		QString dataStr(tempString.c_str());
		
		QStringList list1 = dataStr.split("@");

		if (requestingLevelID)
		{
			
			if (list1[0].compare(QString("0"))==0)
			{
			
				std::cout<<"level ID given: "<<std::endl<<list1[1].toStdString();
				editGraph->id=list1[1].toStdString();
				
				requestingLevelID=0;
			}



			return;
		}
		


		
		if (list1[0].compare(QString("0"))==0 && levelSuccess==0)
		{

			levelSuccess=1;
			
			std::cout<<"level submission success"<<std::endl;
			submitSolution();
			
		}
		else if (list1[0].compare(QString("0"))==0 && levelSuccess==1)
		{
			solutionSuccess=1;
			
			std::cout<<"solution submission success"<<std::endl;
			
			submissionFinished();
			
		}
		else if (list1[0].compare(QString("1"))==0)
		{
			serverReply=list1[1].toStdString();
			submissionFinished();

		}


	
	
	}

	else if (mode==4)//levels list
	{
	std::cout<<"replyFinished 4"<<std::endl;
		
		if (option==0 && !levelsListComplete)
		{
			std::string tempString(data);

		
			QString dataStr(tempString.c_str());
			std::cout<<dataStr.toStdString()<<std::endl;
		
			QStringList list1 = dataStr.split("@");

		
			if (list1[0].compare(QString("0"))==0)//list of levels
			{
				maxPageNum=list1[1].toInt();
				levelsNumber=list1[2].toInt();	
				//request all the levels that we got from the list
				for (int i=0;i<list1[2].toInt();++i)
				{
					std::cout<<"saving level "<<list1[3+i].toStdString()<<std::endl;
					levelsToGet.push_back(list1[i+3].toInt());
				}
					
			levelsListComplete=1;
			}
			
			if (levelsToGet.size()>0)
			{
				std::string url="http://mgg.skomialek.com/deviceAPI/getLevel.php?s=";
				url.append(user->sessionID);
				url.append("&id=");
				url.append(QString::number(levelsToGet[0]).toStdString());
			
				networkHandler->get(url.c_str());
			}
			return;
			
		}

		
		else if (option==0 && levelsListComplete)
		{
			
			std::string tempString(data);

		
			QString dataStr(tempString.c_str());
			std::cout<<dataStr.toStdString()<<std::endl;
		
			QStringList list1 = dataStr.split("@");

		
			if (list1[0].compare(QString("0"))==0)//list of levels
			{

				std::string filename=levelDir;
				filename.append(currentMode);
				filename.append(QString::number(levelsToGet[0]).toStdString());
				filename.append(".lev");
				levelsToGet.erase(levelsToGet.begin());
				networkHandler->getFile((list1[1].toStdString()).c_str(),filename.c_str());
				
				std::cout<<"Saving level to "<<filename<<std::endl;
				std::cout<<levelsToGet.size()<<std::endl;
				
				if (levelsToGet.size()==0)
				{
					std::cout<<"all levels requested"<<std::endl;
					levelsListComplete=0;
				}
				else
				{

				}
				
			}	

		}
		
		
		
		else if (option==1) //file saving
		{

			if (avatarRequested)
			{
				std::cout<<"avatar received"<<std::endl;
				std::string filename=avatarDir;
				if (graph==NULL)
					return;

				filename.append(QString::number(graph->creatorID).toStdString());
				creatorPix.load(filename.c_str());
				std::cout<<creatorPix.size().width()<<std::endl;
				avatarRequested=0;
				pixIDs.push_back(graph->creatorID);
				return;
			}

			
			std::cout<<"level saved "<<networkHandler->fileName<<std::endl;
				
			readLevels(currentMode.c_str());
		
				delete listWidget;
	
				listWidget = new QListWidget();
	//			listWidget->setSortingEnabled(true);
		
		
	
				listWidget->resize(420,410);
			
				connect(listWidget,SIGNAL(pressed(QModelIndex)),this,SLOT(levelChosen(QModelIndex)));
			
				for (int i=0;i<levels.size();++i)
				{
					std::string tmp=levels[i];
					tmp.erase(levels[i].length()-4);
					new QListWidgetItem(tmp.c_str(), listWidget);
				}	 
		
		
				scene->addWidget(listWidget);
			
			--levelsNumber;
			if (levelsNumber==0)
			{
		
				std::cout<<"levels number reached 0"<<std::endl;
				
			}
			else
			{
					std::string url="http://mgg.skomialek.com/deviceAPI/getLevel.php?s=";
					url.append(user->sessionID);
					url.append("&id=");
					url.append(QString::number(levelsToGet[0]).toStdString());
			
					networkHandler->get(url.c_str());

			}
		}

	}
	

}


void View::login()
{

	if(readLoginFile())
	{
		std::cout<<"login information found, loging..."<<std::endl;
		QString str(loginLine.c_str());
		
		std::cout<<loginLine.c_str()<<std::endl;
		
		QStringList list1 = str.split("@");
		
		user->username=list1[0].toStdString();
		user->password=list1[1].toStdString();
		user->userID=list1[2].toInt();

	std::string url="http://mgg.skomialek.com/deviceAPI/login.php?u=";
	url.append(user->username);
	url.append("&p=");
	url.append(user->password);
	
	
		usernameRequested=0;
		avatarRequested=0;
		networkHandler->get(url.c_str());
		
		
		

	}
	else if (!user->loggedIn)
	{
		std::cout<<"login information not found, asking user..."<<std::endl;
		user->loggedIn=0;
		start();

	}
	


}


int View::readLoginFile()
{
  	if (!validationMode)
	{
		std::ifstream myfile ("/home/opt/mgraph/login");
	if (myfile.is_open())
	{
		while (! myfile.eof() )
		{
			getline (myfile,loginLine);
		}
		myfile.close();
		std::cout<<loginLine<<std::endl;
		return 1;

	}

      else std::cout << "Unable to open file"<<std::endl; 
      return 0;
	}
    	else
	{
		std::ifstream myfile ("/home/opt/mgraph/loginValidator");
	if (myfile.is_open())
	{
		while (! myfile.eof() )
		{
			getline (myfile,loginLine);
		}
		myfile.close();
		loginLine="validator@dupa@2";
		std::cout<<loginLine<<std::endl;
		return 1;

	}

      else std::cout << "Unable to open file"<<std::endl; 
      return 0;
	}

	
}


void View::loginOk()
{

	std::string usernameS = std::string(username->text().toStdString());
	std::string passwordS = std::string(password->text().toStdString());

	std::cout<<"logging with username "<<usernameS<<" and password "<<passwordS<<std::endl;

	std::string url="http://mgg.skomialek.com/deviceAPI/login.php?u=";
	url.append(usernameS);
	url.append("&p=");
	url.append(passwordS);
	
	networkHandler->get(url.c_str());


}


void View::toRegister()
{
	
			registrationFailed=-1;
			mode=6;

		if (ok!=NULL)
		{
			delete ok;
			ok=NULL;
		}
		
		
		if (username!=NULL)
		{
			delete username;
			username=NULL;
		}

		if (password!=NULL)
		{
			delete password;
			password=NULL;
		}
		if (email!=NULL)
		{
			delete email;
			email=NULL;
		}
		if (infoLayout!=NULL)
		{
			delete infoLayout;
			infoLayout=NULL;
		}
		if (reg!=NULL)
		{
			delete reg;
			reg=NULL;
		}
		if (anon!=NULL)
		{
			delete anon;
			anon=NULL;
		}
			
			
			init();
}


void View::anonLogin()
{
		user->username="Anonymous";
		networkHandler->get("http://mgg.skomialek.com/deviceAPI/login.php?u=Anonymous");

}


int View::submitSolution()
{
	if (!readyToSubmit)
		return 0;
	
	usernameRequested=0;
	readyToSubmit=0;
	solutionSuccess=0;
	std::string file = levelDir;
	file.append("mine/");
	file.append(editGraph->id.append(".sol"));
	std::string url="http://mgg.skomialek.com/deviceAPI/submitSolution.php?s=";
	url.append(user->sessionID);
	url.append("&id=");
	url.append(editGraph->id);
	
	networkHandler->post(url.c_str(),file.c_str());
	
	
	std::cout<<"submitting solution "<<file<<std::endl;
	
	
	return 1;
}

//do we need to move this to replyFInished to make sure that it is submitted

int View::submitLevel()
{
	if (!readyToSubmit)
		return 0;
	
	usernameRequested=0;
	levelSuccess=0;
	std::string file = levelDir;
	file.append("mine/");
	file.append(editGraph->id).append(".lev");
	
	std::string url="http://mgg.skomialek.com/deviceAPI/submitLevel.php?s=";
	url.append(user->sessionID);
	url.append("&id=");
	url.append(editGraph->id);
	
	networkHandler->post(url.c_str(),file.c_str());
	
	std::cout<<"submitting level "<<file<<std::endl<<user->sessionID;
	

	
	return 1;

}



void View::submissionFinished()
{

	{
		if (solutionSuccess && levelSuccess)
		{
			std::cout<<"submission success"<<std::endl;
			levelsPosted.push_back(editGraph->id);
			submissionFinishedCounter=0;
			if (replyText!=NULL)
			{
				delete replyText;
				replyText=NULL;
			}
			replyText=scene->addText("submission successful");
			replyText->setPos(520,420);

		}
		else
		{
			std::cout<<"submission failed, please try again"<<std::endl;
			readyToSubmit=1;
			if (replyText!=NULL)
			{
				delete replyText;
				replyText=NULL;
			}
			replyText=scene->addText(serverReply.c_str());
			replyText->setPos(520,420);
			submissionFinishedCounter=0;

		}

	}

	
}



void View::checkSubmittedLevels()
{
	std::cout<<"checking submitted levels"<<std::endl;
	
	for (int i=0;i<levelsPosted.size();++i)
	{
		std::cout<<"checking level"<<i<<std::endl;
	}//add to reply finished correct information
}



void View::getLevelsList(const char* type_)
{

	std::cout<<"requesting levels list"<<std::endl;
	//reques
	levelsListComplete=0;
	usernameRequested=0;
	avatarRequested=0;
	std::string url="http://mgg.skomialek.com/deviceAPI/getLevels.php?s=";
	url.append(user->sessionID);
	url.append("&c=");
	url.append("recent");
	url.append("&max=");
	url.append("10");
	url.append("&p=");
	url.append(QString::number(pageNum).toStdString());

	std::cout<<url<<std::endl;
	
	networkHandler->get(url.c_str());
	
}


void View::levelTick()
{

	
	if (graph!=NULL)
	{
		--graph->currentTime;
	//	iconTimer->update();
		if (graph->currentTime<5)
			vibrate(2);

		if (graph->currentTime==0)
		{
			fail();
		}
	}
	
}

void View::fail()
{
	if (replyText!=NULL)
	{
		delete replyText;
		replyText=NULL;
	}

	replyText=scene->addText("You lost!");
	replyText->setPos(350,420);
	vibrate(2);
	
	std::string url="http://mgg.skomialek.com/deviceAPI/submitResult.php?";
	url.append("s=");
	url.append(user->sessionID);
	url.append("&");
	url.append("id=");
	url.append(currentGraphId);
	url.append("&t=");
	url.append(QString::number(graph->time).toStdString());
	url.append("&r=-1");
	
	std::cout<<"FAILED "<<url<<std::endl;

	networkHandler->get(url.c_str());
	
	graph->currentTime=graph->time;
	reset();

}

void View::newestClicked()
{
	if (!(levelsNumber==0))
		return;

	std::cout<<"newest clicked"<<std::endl;
	system("rm /home/opt/mgraph/levels/newest/*");
	currentMode="newest/";	
	
	getLevelsList("new");
	

}

void View::mineClicked()
{
	currentMode="mine/";

	readLevels(currentMode.c_str());
		
	delete listWidget;

	listWidget = new QListWidget();
				//listWidget->setSortingEnabled(true);

	listWidget->resize(420,410);
	connect(listWidget,SIGNAL(pressed(QModelIndex)),this,SLOT(levelChosen(QModelIndex)));
			
	for (int i=0;i<levels.size();++i)
	{
		std::string tmp=levels[i];
		tmp.erase(levels[i].length()-4);
		new QListWidgetItem(tmp.c_str(), listWidget);
	}	 
		

	scene->addWidget(listWidget);

}

void View::leftClicked()
{
	if (pageNum>1 && levelsNumber==0)
	{
		--pageNum;
	}
	
	else
	{
		std::cout<<"grrr "<<levelsNumber<<std::endl;
		return;
	}
	system("rm /home/opt/mgraph/levels/newest/*");
	currentMode="newest/";	
	
	getLevelsList("new");

}

void View::rightClicked()
{
	if (pageNum<maxPageNum && levelsNumber==0)
		++pageNum;
	else
		return;
	system("rm /home/opt/mgraph/levels/newest/*");
	currentMode="newest/";	
	
	getLevelsList("new");

}


void View::getUserName(int userID)
{
	usernameRequested=1;
	std::string url="http://mgg.skomialek.com/deviceAPI/getUserName.php?s=";
	url.append(user->sessionID);
	url.append("&id=");
	url.append(QString::number(userID).toStdString());
	
	std::cout<<"getting user name "<<url<<std::endl;

	networkHandler->get(url.c_str());
}

void View::getUserAvatar(int userID)
{

	avatarRequested=1;
	std::string url="http://mgg.skomialek.com/deviceAPI/getUserAvatar.php?s=";
	url.append(user->sessionID);
	url.append("&id=");
	url.append(QString::number(userID).toStdString());
	
	std::cout<<"getting user avatar"<<url<<std::endl;

	networkHandler->get(url.c_str());


}

void View::resetScreen()
{
	 osso_display_state_on(_osso);
	 osso_display_blanking_pause(_osso);
		 
}



Someone::Someone(int id_, std::string name_):id(id_), name(name_)
{

}
