#include <node.h>

View* Node::myView=NULL;

Node::Node(int x_,int y_, int nodeValue_):QGraphicsItem(0),x(x_),y(y_),nodeValue(nodeValue_)
{

	objectType=node;
	setPos(x,y);
	size=40*myView->scale;
	startingPoint=0;
	endingPoint=0;
	centerX=x+size/2.0;
	centerY=y+size/2.0;

	touched=0;
	
	if (nodeValue>9)
		nodeValue=9;

	jD=0.1;
	
	currentValue=nodeValue;
}

Node::~Node()
{

}


void Node::reset()
{
	currentValue=nodeValue;
}

void Node::hit()
{
	
	myView->vibrate(0);

	if (myView->mode==1 || myView->mode==99)
	{
		--currentValue;
		
		
		
		if (currentValue<0)
		{
			currentValue=0;
			myView->vibrate(2);
			myView->reset();
			return;

		}	
		
		--myView->graph->value;

		if (myView->graph->value==0)
		{
			myView->win();

		}
	}
	else if (myView->mode==3)
	{
		++currentValue;
		++nodeValue;
		
		
		myView->editGraph->addVisitedNode(myView->getNodeIndex(this));
		myView->readyToSave=1;
		myView->iconSave->update();

		
		if (currentValue>9)
		{
			currentValue=9;
			myView->vibrate(2);	
			myView->editNodesReset();

		}	
		
	}
}


QRectF Node::boundingRect() const
{
	 
 	return QRectF(0,0,size,size);
}

void Node::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

	painter->save();
	painter->setBrush(touched ? Qt::magenta : QColor(220,220,220));
	painter->setPen(touched ? Qt::magenta : QColor(220,220,200));
	painter->setOpacity(myView->moveMode ? 0.3 : 0.8);
	painter->drawEllipse(boundingRect());
	
	painter->setBrush(Qt::red);
	painter->setPen(Qt::red);
	QFont serifFont("Times", 30*myView->scale, QFont::Bold);
	painter->setFont(serifFont);
	painter->setOpacity(0.4);
	painter->drawText(10*myView->scale,30*myView->scale,QString::number(currentValue));
											
	
	painter->restore();

}


void Node::advance(int step)
{
	if (!step)
		return;

	
	if (myView->moveMode) {
		qreal XX=x;
		qreal YY=y;
		
		jD+=jD;

		if (jD>20)
			jD=-0.01;

		if (jD<-20)
			jD=0.01;	
		
		XX+=jD;
	//	YY+=jD;
		setPos(XX,YY);
	}
	else
		setPos(x,y);

	centerX=x+size/2.0;
	centerY=y+size/2.0;
	
}

