#include <QtGui>
#include <QApplication>
#include <iostream>
#include <view.h>
#include <node.h>
#include <iostream>
#include <QListWidget>
#include <validator.h>
#include <stdlib.h>


int main(int argc, char **argv)
{
	QApplication::setGraphicsSystem(QString("opengl"));
	QApplication app(argc, argv);
	QGraphicsScene scene;
	scene.setSceneRect(0, 0, 800, 480);
	scene.setItemIndexMethod(QGraphicsScene::NoIndex);


	system("rm /home/opt/mgraph/levels/newest/*");
	system("rm /home/opt/mgraph/avatars/*");
	
	//scene.setBackgroundBrush(Qt::cyan);
	
	std::cout<<"scene created"<<std::endl;
	
	View* view;
	
	if (argc>1)
	{
		if (strcmp(argv[1],"validator")==0)
		{
			view = new View(&scene,1, new Validator());
			Node::myView=view;
			Edge::myView=view;
			Icon::myView=view;
			View::app=&app;
			view->init();
		}
		else 
			view = new View(&scene);
	}
	else
		view = new View(&scene);
	
	
	view->setCacheMode(QGraphicsView::CacheNone);
	view->setViewportUpdateMode(QGraphicsView::FullViewportUpdate);
	view->setWindowTitle(QT_TRANSLATE_NOOP(QGraphicsView, "MGraph"));
	view->resize(800, 480);
	view->setBackgroundBrush(QPixmap("/home/opt/mgraph/images/milky.jpg"));
	
	std::cout<<"view set"<<std::endl;
	
	Node::myView=view;
	Edge::myView=view;
	Icon::myView=view;
	View::app=&app;
	
		
	
	view->showFullScreen();
	
	
	
	 QTimer timer;
	 QObject::connect(&timer, SIGNAL(timeout()), &scene, SLOT(advance()));
	timer.start(10);

	 QTimer timerCheck;
         QObject::connect(&timerCheck, SIGNAL(timeout()), view, SLOT(checkSubmittedLevels()));
	 timerCheck.start(100000);
			    
	 QTimer timerScreen;
         QObject::connect(&timerScreen, SIGNAL(timeout()), view, SLOT(resetScreen()));
	 timerScreen.start(10000);
	
	 return app.exec();
				 




}
