#ifndef FINGER_H
#define FINGER_H

#include <QGraphicsItem>
#include <QPainter>
#include <baseobject.h>
#include <QGraphicsScene>
#include <edge.h>
#include <bonus.h>
#include <view.h>
#include <QPainterPath>

class Edge;
class View;

class Finger: public QGraphicsItem, BaseObject
{

	public:
		Finger(int x_,int y_,View* view_);

		
		 QRectF boundingRect() const;
		 void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
		 void advance(int step);
			
		qreal x;
		qreal y;	
	
		std::vector<qreal> xx;
		std::vector<qreal> yy;
		
		int reseted;		

		QPainterPath shape() const;
	

		qreal tempDist;
		
		View* myView;
		Edge* edgeActive;
		Node* nodeActive;
		Node* lastNode;
		Node* previousNode;
		int canChange;
		int starting;
		
		~Finger();
		int draw;
		
};




#endif
