#ifndef EDGE_H
#define EDGE_H

#include <node.h>
#include <QGraphicsItem>
#include <vector>
#include <math.h>
#include <iostream>
#include <baseobject.h>
#include <bonus.h>
#include <view.h>

class Bonus;
class Node;
class View;

#define PI 3.14159265

class Edge: public QGraphicsItem,BaseObject
{
	public:
		Edge(Node* nodeA_, Node* nodeB_, int bonusesNumber_=0);

		 QRectF boundingRect() const;
		 void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

		 void advance(int step);

		void reset();
		 
		int bonusesNumber;

		static View* myView;
		 
		 Node* nodeA;
		 Node* nodeB;

		qreal rotation;
		qreal length;
		
		 QPainterPath shape() const;

		 int inProgress;

		 std::vector<Bonus*> bonuses; 
		 void addBonus(int value_);
		 void updateBonuses();

		 void deleteMe(Bonus* bonus_);

		 ~Edge();
};


#endif
