#include <edge.h>

View* Edge::myView=NULL;


Edge::Edge(Node* nodeA_, Node* nodeB_, int bonusesNumber_):QGraphicsItem(0), nodeA(nodeA_), nodeB(nodeB_), bonusesNumber(bonusesNumber_)
{

	
	objectType=edge;
	inProgress=0;
	
	rotation=(atan2(nodeA->centerX-nodeB->centerX,nodeA->centerY-nodeB->centerY))*180.0/PI;
	
	length=sqrt(pow(nodeA->centerX-nodeB->centerX,2)+pow(nodeA->centerY-nodeB->centerY,2));
	
	setPos(nodeA->centerX,nodeA->centerY);
	setRotation(180-rotation);

	for (int i=0;i<bonusesNumber;++i)
	{
		addBonus(10);
	}
}


void Edge::reset()
{


	
	for (int i=0;i<bonuses.size();++i)
	{
	//	std::cout<<"deleting bonus "<<i<<std::endl;
	//	deleteMe(bonuses[i]);
	}
	
	
	for (int i=0;i<bonusesNumber;++i)
	{
	//	addBonus(10);
	//	scene()->addItem(bonuses.back());
		bonuses[i]->scale=1;
		bonuses[i]->consumed=0;
		bonuses[i]->visible=1;
	}


}

Edge::~Edge()
{

	for (int i=0;i<bonuses.size();++i)
	{
		delete bonuses[i];
	}

}


QRectF Edge::boundingRect() const
{
	 return QRectF(0,-5,15,length);
}

 QPainterPath Edge::shape() const
{

	QPainterPath path;

	path.addRect(boundingRect());
	
	return path;

}

void Edge::addBonus(int value_)
{

	qreal distance=0.5*length;
	
	
//	bonuses.push_back(new Bonus(value_,nodeA->centerX+distance*sin((rotation-180)*PI/180),nodeA->centerY+distance*cos((rotation-180)*PI/180)));
	bonuses.push_back(new Bonus(value_,0,0,this));
	updateBonuses();

}

void Edge::deleteMe(Bonus* bonus_)
{
//	std::cout<<"deleting"<<std::endl;

	
	for (int i=0;i<bonuses.size();++i)
	{

		if (bonuses[i]==bonus_ && bonus_!=NULL)
		{
	//		bonuses.erase(bonuses.begin()+i);
	//		delete bonus_;
			bonus_->visible=0;
			return;
		}

	}
}
void Edge::updateBonuses()
{

	int number=bonuses.size();

	qreal distance=1.0/(number+1)*length;
	
	for (int i=0; i<number; ++i)
	{
		bonuses[i]->x=nodeA->centerX+(i+1)*distance*sin((rotation-180)*PI/180);
		bonuses[i]->y=nodeA->centerY+(i+1)*distance*cos((rotation-180)*PI/180);
		

	}

}


void Edge::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

	setZValue(-1);
	painter->save();
	
	QPen pen;
	pen.setWidth(4);
	pen.setColor(inProgress? Qt::green : QColor(255,255,240));
	
	painter->setPen(pen);
	painter->setOpacity(myView->moveMode ? 0.3 : 1);

	
	painter->drawLine(0,0,0,length);
//	painter->drawRect(boundingRect());
	painter->restore();
	
}


void Edge::advance(int step)
{
	if (!step)
		return;

	rotation=(atan2(nodeA->centerX-nodeB->centerX,nodeA->centerY-nodeB->centerY))*180.0/PI;
	
	length=sqrt(pow(nodeA->centerX-nodeB->centerX,2)+pow(nodeA->centerY-nodeB->centerY,2));
	
	setPos(nodeA->centerX,nodeA->centerY);
	setRotation(180-rotation);

	updateBonuses();

}

			
