#include <button.h>

Button::Button(int x_, int y_, int type_, View* myView_): QGraphicsItem(0),x(x_),y(y_),type(type_), myView(myView_)
{
	scale=0.1;
	setPos(x,y);
	setScale(this->scale);

	objectType=button;
}



QRectF Button::boundingRect() const
{
	        return QRectF(0,0,300,120);
}


void Button::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

	painter->save();
	
	painter->setBrush(myView->user->loggedIn ? Qt::black : Qt::red);
	painter->setOpacity(0.5);
	painter->drawRoundedRect(boundingRect(),20.0,15.0);

	        painter->setBrush(QColor(0,191,255));
		painter->setPen(QColor(0,191,255));
		QFont serifFont("Times", 30, QFont::Bold);
		painter->setFont(serifFont);
		painter->setOpacity(1);

							
	
	if (type==0)
	{

		painter->drawText(15,60,"New Game");

	}
	else if (type==1)
	{

		painter->drawText(15,60,"Editor");

	}
	else if (type==2)
	{

		painter->drawText(15,60,"Register");

	}
	
	painter->restore();
}


void Button::advance(int step)
{

	if (!step)
		return;
	
	this->scale+=0.05;
	if (this->scale>=1)
		this->scale=1;

	setPos(x,y);
	setScale(this->scale);

}

